/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.export;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.osee.icteam.reqif.export.WordMLContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlFactory;
import org.eclipse.rmf.reqif10.xhtml.XhtmlInlPresType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPType;

public class CustomisedXmlTextInputStream
extends BufferedInputStream {
    private final StringBuilder buffer = new StringBuilder();
    private final StringBuilder b = new StringBuilder();
    private static final String STOP_PARAGRAPH = "</w:p>";
    private static final String WORD_UNDERLINE = "<w:u";
    private static final String WORD_ITALIC = "<w:i>";
    private static final String END_WORDML_TEXT = "</w:t>";
    private static final String WORD_BOLD = "<w:b>";
    private static final String START_PICT = "<w:binData";
    private static final String START_WR = "<w:r";
    private static final String END_WR = "</w:r>";
    XhtmlDivType xhmtlDiv;
    byte[] bTemp = new byte[16000];
    int j = 1;

    public CustomisedXmlTextInputStream(InputStream arg0) {
        super(arg0);
    }

    public CustomisedXmlTextInputStream(String input, XhtmlDivType div) throws UnsupportedEncodingException {
        this(new ByteArrayInputStream(input.getBytes("UTF-8")));
        this.xhmtlDiv = div;
    }

    @Override
    public synchronized int read() throws IOException {
        int value = this.process(super.read());
        return value;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        this.bTemp[off] = (byte)c;
        b[off] = (byte)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                if (c != -1) {
                    this.bTemp[off + this.j] = (byte)c;
                    b[off + i] = (byte)c;
                    ++this.j;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return i;
    }

    private int readFromOriginalBuffer() throws IOException {
        return super.read();
    }

    private int process(int value) throws IOException {
        String tag;
        this.buffer.append((char)value);
        if ((char)value == '>' && (tag = this.buffer.toString()).endsWith(STOP_PARAGRAPH)) {
            this.createSubInputStream(tag);
            this.buffer.delete(0, this.buffer.length());
            this.bTemp = new byte[16000];
            this.j = 1;
        }
        if (this.buffer.toString().endsWith(START_PICT)) {
            this.buffer.delete(0, this.buffer.length());
            int value1 = this.readFromOriginalBuffer();
            while ((char)value1 != '<') {
                value1 = this.readFromOriginalBuffer();
            }
            this.buffer.append((char)this.readFromOriginalBuffer());
            while (!this.buffer.toString().endsWith(STOP_PARAGRAPH)) {
                value1 = this.readFromOriginalBuffer();
                this.buffer.append((char)value1);
            }
            this.buffer.delete(0, this.buffer.length());
        }
        return value;
    }

    private void createSubInputStream(String tag) throws IOException {
        int c;
        ArrayList<WordMLContent> listWorMLContents = new ArrayList<WordMLContent>();
        ByteArrayInputStream in = new ByteArrayInputStream(tag.getBytes("UTF-8"));
        StringBuilder bufferTemp = new StringBuilder();
        StringBuilder bufferWr = new StringBuilder();
        String xhmtlData = "";
        while ((c = in.read()) != -1) {
            bufferTemp.append((char)c);
            bufferWr.append((char)c);
            if ((char)c != '>') continue;
            String temp = bufferTemp.toString();
            if (temp.endsWith(END_WORDML_TEXT)) {
                xhmtlData = temp.replace(END_WORDML_TEXT, "");
            }
            if (temp.endsWith(END_WR)) {
                bufferWr.delete(0, bufferWr.length());
            }
            bufferTemp.delete(0, bufferTemp.length());
            if (xhmtlData.length() <= 0) continue;
            boolean bold = false;
            boolean italic = false;
            if (bufferWr.toString().contains(WORD_BOLD)) {
                bold = true;
            }
            if (bufferWr.toString().contains(WORD_ITALIC)) {
                italic = true;
            }
            if (bufferWr.toString().contains(WORD_UNDERLINE)) {
                // empty if block
            }
            if (xhmtlData.contains("&amp;")) {
                xhmtlData = xhmtlData.replace("&amp;", "&");
            }
            WordMLContent content = new WordMLContent();
            content.setInputString(xhmtlData);
            content.setBold(bold);
            content.setItalic(italic);
            listWorMLContents.add(content);
            xhmtlData = "";
        }
        if (!tag.contains("<w:t>")) {
            WordMLContent content = new WordMLContent();
            content.setInputString("");
            content.setBold(false);
            content.setItalic(false);
            listWorMLContents.add(content);
        }
        this.createxhtmlContent(listWorMLContents);
    }

    private void createxhtmlContent(List<WordMLContent> listWorMLContents) {
        XhtmlPType xhtmlPType = null;
        if (listWorMLContents.size() > 0) {
            xhtmlPType = XhtmlFactory.eINSTANCE.createXhtmlPType();
        }
        if (xhtmlPType != null) {
            for (WordMLContent wordMLContent : listWorMLContents) {
                XhtmlInlPresType xhtmlBoldType;
                String xhmtlData = wordMLContent.getInputString();
                boolean bold = wordMLContent.isBold();
                boolean italic = wordMLContent.isItalic();
                if (bold && italic) {
                    xhtmlBoldType = XhtmlFactory.eINSTANCE.createXhtmlInlPresType();
                    XhtmlInlPresType xhtmlitalicType = XhtmlFactory.eINSTANCE.createXhtmlInlPresType();
                    xhtmlitalicType.getMixed().add((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, (Object)xhmtlData);
                    xhtmlBoldType.getI().add((Object)xhtmlitalicType);
                    xhtmlPType.getB().add((Object)xhtmlBoldType);
                    continue;
                }
                if (bold) {
                    xhtmlBoldType = XhtmlFactory.eINSTANCE.createXhtmlInlPresType();
                    xhtmlBoldType.getMixed().add((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, (Object)xhmtlData);
                    xhtmlPType.getB().add((Object)xhtmlBoldType);
                    continue;
                }
                if (italic) {
                    XhtmlInlPresType xhtmlitalicType = XhtmlFactory.eINSTANCE.createXhtmlInlPresType();
                    xhtmlitalicType.getMixed().add((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, (Object)xhmtlData);
                    xhtmlPType.getI().add((Object)xhtmlitalicType);
                    continue;
                }
                xhtmlPType.getMixed().add((EStructuralFeature)XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT, (Object)xhmtlData);
            }
            this.xhmtlDiv.getP().add((Object)xhtmlPType);
        }
    }
}

