/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImportReqIfDialog
extends TitleAreaDialog {
    private Combo fileTypeCombo;
    private Button browseButton;
    private String sReqIFFileName = "";
    private Combo fileText;
    private String sFileName = "";
    Artifact activeProject;

    public ImportReqIfDialog(Shell parentShell, Artifact parentArtifact) {
        super(parentShell);
        this.activeProject = parentArtifact;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Import Requirments from REQIF format to ICTeam");
        parent.getShell().setText("Import Requirments");
        this.getButton(0).setEnabled(false);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        fileSelectionArea.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true);
        fileSelectionArea.setLayoutData((Object)layoutData);
        Label label1 = new Label(fileSelectionArea, 0);
        label1.setText("Module Name");
        this.fileText = new Combo(fileSelectionArea, 0);
        GridData gridData1 = new GridData(768);
        this.fileText.setLayoutData((Object)gridData1);
        String[] moduleNames = this.importModuleCombo();
        if (moduleNames != null) {
            this.fileText.setItems(moduleNames);
        }
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportReqIfDialog.this.validateCombo();
            }
        });
        Label dummyLabel = new Label(fileSelectionArea, 0);
        dummyLabel.setText("");
        Label label2 = new Label(fileSelectionArea, 0);
        label2.setText("Select ReqIF File:");
        this.fileTypeCombo = new Combo(fileSelectionArea, 0);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.fileTypeCombo.setLayoutData((Object)gridData);
        this.fileTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportReqIfDialog.this.validateCombo();
            }
        });
        this.browseButton = new Button(fileSelectionArea, 8);
        this.browseButton.setText("Browse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(ImportReqIfDialog.this.getShell(), 4096);
                String[] extensions = new String[]{"*.reqif", "*.xml"};
                fileDialog.setFilterExtensions(extensions);
                String selectedFile = fileDialog.open();
                ImportReqIfDialog.this.fileTypeCombo.setText(selectedFile);
                ImportReqIfDialog.this.validateCombo();
            }
        });
        return fileSelectionArea;
    }

    protected String[] importModuleCombo() {
        String[] arr = null;
        ArrayList<String> projectsList = new ArrayList<String>();
        try {
            List children = this.activeProject.getChildren();
            for (Artifact artifact : children) {
                if (!artifact.getArtifactType().equals("")) continue;
                projectsList.add(artifact.getName());
            }
        }
        catch (OseeCoreException e) {
            e.printStackTrace();
        }
        if (!projectsList.isEmpty()) {
            arr = new String[projectsList.size()];
            int i = 0;
            while (i < projectsList.size()) {
                arr[i] = (String)projectsList.get(i);
                ++i;
            }
        }
        return arr;
    }

    private void validateCombo() {
        boolean isPageComplete = true;
        String fileNameString = this.fileText.getText();
        if (fileNameString == null || fileNameString.length() == 0) {
            this.setMessage("Please enter a fileName");
            isPageComplete = false;
            if (this.validateString(fileNameString)) {
                this.setMessage("Please enter a valid fileName");
                isPageComplete = false;
            } else {
                isPageComplete = true;
            }
        } else if (isPageComplete) {
            String selectedFile = this.fileTypeCombo.getText();
            if (selectedFile != null && !"".equals(selectedFile)) {
                File f = new File(selectedFile);
                if (f.exists()) {
                    this.setMessage(null);
                } else {
                    this.setMessage("File does not exist");
                    isPageComplete = false;
                }
            } else {
                this.setMessage("Select the valid ReqIf File");
                isPageComplete = false;
            }
        }
        if (isPageComplete) {
            this.setMessage("");
        }
        this.getButton(0).setEnabled(isPageComplete);
    }

    private boolean validateString(String selectedPrj) {
        char[] charArray = selectedPrj.toCharArray();
        boolean isValid = Character.isJavaIdentifierStart(charArray[0]);
        if (isValid) {
            int i = 1;
            while (i < charArray.length) {
                if (!Character.isJavaIdentifierPart(charArray[i])) {
                    return true;
                }
                ++i;
            }
        }
        return true;
    }

    public String getFileName() {
        return this.sFileName;
    }

    public String getReqIFFileName() {
        return this.sReqIFFileName;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    private void saveInput() {
        this.sFileName = this.fileText.getText();
        this.sReqIFFileName = this.fileTypeCombo.getText();
    }
}

