/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.traceability;

import java.nio.CharBuffer;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.osee.define.ide.traceability.ITraceUnitResourceLocator;
import org.eclipse.osee.define.ide.traceability.ResourceIdentifier;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class DemoTraceUnitResourceLocator
implements ITraceUnitResourceLocator {
    public boolean isValidDirectory(IFileStore fileStore) {
        boolean isValid = false;
        String name = fileStore.getName();
        if (Strings.isValid((String)name) && fileStore.fetchInfo().isDirectory()) {
            isValid = !name.startsWith(".");
        }
        return isValid;
    }

    public boolean isValidFile(IFileStore fileStore) {
        boolean isValid = false;
        String name = fileStore.getName();
        if (Strings.isValid((String)name) && !fileStore.fetchInfo().isDirectory()) {
            isValid = true;
        }
        return isValid;
    }

    public boolean hasValidContent(CharBuffer fileBuffer) {
        return fileBuffer != null && fileBuffer.length() > 0;
    }

    public ResourceIdentifier getIdentifier(IFileStore fileStore, CharBuffer fileBuffer) throws Exception {
        return new ResourceIdentifier(fileStore.getName());
    }

    public ArtifactTypeToken getTraceUnitType(String name, CharBuffer fileBuffer) {
        return CoreArtifactTypes.CodeUnit;
    }
}

