/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;

public class ArtifactImage {
    private ArtifactTypeToken artifactType;
    @JsonSerialize(using=ToStringSerializer.class)
    private Long artifactTypeId;
    private String artifactTypeName;
    private String imageName;
    private String baseUrl;

    public ArtifactImage(ArtifactTypeToken artifactType, String imageName, String baseUrl) {
        this.artifactType = artifactType;
        this.imageName = imageName;
        this.baseUrl = baseUrl;
    }

    @JsonIgnore
    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public static ArtifactImage construct(ArtifactTypeToken artifactType, String imageName) {
        return ArtifactImage.construct(artifactType, imageName, null);
    }

    public static ArtifactImage construct(ArtifactTypeToken artifactType, String imageName, String baseUrl) {
        return new ArtifactImage(artifactType, imageName, baseUrl);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Long getArtifactTypeId() {
        if (this.artifactType != null) {
            return this.artifactType.getId();
        }
        return this.artifactTypeId;
    }

    public void setArtifactTypeId(Long artifactTypeId) {
        this.artifactTypeId = artifactTypeId;
    }

    public String getArtifactTypeName() {
        if (this.artifactType != null) {
            return this.artifactType.getName();
        }
        return this.artifactTypeName;
    }

    public void setArtifactTypeName(String artifactTypeName) {
        this.artifactTypeName = artifactTypeName;
    }
}

