/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.panels;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ListSelectionPanel
extends Composite {
    private TableViewer tableViewer;
    private final IBaseLabelProvider labelProvider;
    private final int width;
    private final int height;

    public ListSelectionPanel(Composite parent, int style, int width, int height, IBaseLabelProvider labelProvider) {
        super(parent, style);
        this.width = width;
        this.height = height;
        this.labelProvider = labelProvider;
        this.createControl(this);
    }

    private void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer = new TableViewer(parent, this.getTableStyle());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider(this.labelProvider);
        GridData gd = new GridData(1808);
        gd.heightHint = this.width;
        gd.widthHint = this.height;
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(parent.getFont());
    }

    private int getTableStyle() {
        return 2820;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.tableViewer.addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
    }

    public void setSelection(int index) {
        this.tableViewer.getTable().select(index);
    }

    public void setSorter(ViewerSorter sorter) {
        this.tableViewer.setSorter(sorter);
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.tableViewer.getSelection();
    }

    public int indexOf(Object object) {
        int found = -1;
        TableItem[] items = this.tableViewer.getTable().getItems();
        int index = 0;
        while (index < items.length) {
            TableItem item = items[index];
            if (item.getData().equals(object)) {
                found = index;
                break;
            }
            ++index;
        }
        return found;
    }
}

