/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;

public final class Address
implements Comparable<Address> {
    private final BranchId branch;
    private final int itemId;
    private final Long transactionId;
    private final GammaId gammaId;
    private ModificationType modType;
    private ApplicabilityId appId;
    private final TxCurrent txCurrent;
    private final boolean isBaseline;
    private TxCurrent correctedTxCurrent;
    private boolean purge;

    public Address(boolean isBaseline, BranchId branch, int itemId, Long transactionId, GammaId gammaId, ModificationType modType, ApplicabilityId appId, TxCurrent txCurrent) {
        this.branch = branch;
        this.itemId = itemId;
        this.transactionId = transactionId;
        this.gammaId = gammaId;
        this.modType = modType;
        this.appId = appId;
        this.txCurrent = txCurrent;
        this.isBaseline = isBaseline;
    }

    public boolean isBaselineTx() {
        return this.isBaseline;
    }

    public boolean isSimilar(Address other) {
        return other != null && other.itemId == this.itemId && other.branch.equals(this.branch);
    }

    public boolean isSameTransaction(Address other) {
        return other != null && this.transactionId.equals(other.transactionId);
    }

    public boolean hasSameGamma(Address other) {
        return other != null && this.gammaId == other.gammaId;
    }

    public boolean hasSameModType(Address other) {
        return this.modType == other.modType;
    }

    public boolean hasSameApplicability(Address other) {
        return this.appId.equals(other.appId);
    }

    public void ensureCorrectCurrent() {
        TxCurrent correctCurrent = TxCurrent.getCurrent((ModificationType)this.modType);
        if (this.txCurrent != correctCurrent) {
            this.correctedTxCurrent = correctCurrent;
        }
    }

    public void ensureNotCurrent() {
        if (this.txCurrent != TxCurrent.NOT_CURRENT) {
            this.correctedTxCurrent = TxCurrent.NOT_CURRENT;
        }
    }

    public boolean hasIssue() {
        return this.purge || this.correctedTxCurrent != null;
    }

    public TxCurrent getCorrectedTxCurrent() {
        return this.correctedTxCurrent;
    }

    public void setCorrectedTxCurrent(TxCurrent correctedTxCurrent) {
        this.correctedTxCurrent = correctedTxCurrent;
    }

    public boolean isPurge() {
        return this.purge;
    }

    public void setPurge(boolean purge) {
        this.purge = purge;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public int getItemId() {
        return this.itemId;
    }

    public Long getTransactionId() {
        return this.transactionId;
    }

    public GammaId getGammaId() {
        return this.gammaId;
    }

    public ModificationType getModType() {
        return this.modType;
    }

    public void setModType(ModificationType modType) {
        this.modType = modType;
    }

    public ApplicabilityId getApplicabilityId() {
        return this.appId;
    }

    public void setApplicabilityId(ApplicabilityId appId) {
        this.appId = appId;
    }

    public TxCurrent getTxCurrent() {
        return this.txCurrent;
    }

    public boolean isBaseline() {
        return this.isBaseline;
    }

    public String toString() {
        return "Address [branchUuid=" + this.branch + ", gammaId=" + this.gammaId + ", itemId=" + this.itemId + ", modType=" + this.modType + ", transactionId=" + this.transactionId + ", txCurrent=" + this.txCurrent + "]";
    }

    @Override
    public int compareTo(Address otherAddress) {
        if (!this.transactionId.equals(otherAddress.transactionId)) {
            return Long.compare(this.transactionId, otherAddress.transactionId);
        }
        return Long.compare(this.gammaId.getId(), otherAddress.gammaId.getId());
    }
}

