/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.operations;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;

public class FilterArtifactTypesByAttributeTypes
extends AbstractOperation {
    private final BranchId branch;
    private final Collection<ArtifactTypeToken> selectedArtifactTypes;
    private final RoughArtifactCollector collector;

    public FilterArtifactTypesByAttributeTypes(BranchId branch, RoughArtifactCollector collector, Collection<ArtifactTypeToken> selectedArtifactTypes) {
        super("Filter Artifact Types", "org.eclipse.osee.framework.skynet.core");
        this.branch = branch;
        this.selectedArtifactTypes = selectedArtifactTypes;
        this.collector = collector;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        HashSet<String> names = new HashSet<String>();
        HashSet<AttributeTypeToken> requiredTypes = new HashSet<AttributeTypeToken>();
        for (RoughArtifact artifact : this.collector.getRoughArtifacts()) {
            if (artifact.getArtifactType() != null && artifact.getArtifactType().getValidAttributeTypes() != null) {
                requiredTypes.addAll(artifact.getArtifactType().getValidAttributeTypes());
                continue;
            }
            names.addAll(artifact.getAttributeTypeNames());
        }
        this.selectedArtifactTypes.clear();
        for (String name : names) {
            requiredTypes.add(AttributeTypeManager.getType(name));
        }
        for (ArtifactTypeToken artifactType : ServiceUtil.getOrcsTokenService().getConcreteArtifactTypes()) {
            List attributeTypes = artifactType.getValidAttributeTypes();
            if (!Collections.setComplement(requiredTypes, (Collection)attributeTypes).isEmpty()) continue;
            this.selectedArtifactTypes.add(artifactType);
        }
    }
}

