/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.access;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.util.AbstractUserGroupImpl;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.OseeSystemArtifacts;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class UserGroupImpl
extends AbstractUserGroupImpl {
    public UserGroupImpl(ArtifactToken userGroupArt) {
        super(userGroupArt);
    }

    public ArtifactTypeToken getArtifactType() {
        return CoreArtifactTypes.UserGroup;
    }

    public Artifact getArtifact() {
        this.checkGroupExists();
        if (this.groupArtifact instanceof Artifact) {
            return (Artifact)this.groupArtifact;
        }
        this.groupArtifact = ArtifactQuery.getArtifactFromId((ArtifactId)this.groupArtifact, (BranchId)CoreBranches.COMMON);
        return (Artifact)this.groupArtifact;
    }

    public boolean addMember(UserId user, boolean persist) {
        this.checkGroupExists();
        Artifact userArt = null;
        userArt = user instanceof Artifact ? (Artifact)user : UserManager.getUserByArtId((ArtifactId)user);
        Artifact group = this.getArtifact();
        if (!group.isRelated(CoreRelationTypes.Users_User, (ArtifactId)userArt)) {
            group.addRelation(CoreRelationTypes.Users_User, userArt);
            if (persist) {
                group.persist("Add Member");
            }
            return true;
        }
        return false;
    }

    public boolean isMember(UserId user) {
        this.checkGroupExists();
        User userArt = UserManager.getUserByArtId((ArtifactId)user);
        return this.getArtifact().isRelated(CoreRelationTypes.Users_User, (ArtifactId)userArt);
    }

    public boolean isMember(Long id) {
        this.checkGroupExists();
        for (RelationLink rel : this.getArtifact().getRelations(CoreRelationTypes.Users_User)) {
            if (!rel.getArtifactIdB().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentUserMember() {
        this.checkGroupExists();
        return this.isMember((UserId)UserManager.getUser());
    }

    protected Artifact getOrCreateGroupArtifact(ArtifactToken token) {
        this.groupArtifact = ArtifactQuery.getArtifactOrNull(token, DeletionFlag.EXCLUDE_DELETED);
        if (this.groupArtifact == null) {
            Artifact userGroupsFolder = this.getOrCreateUserGroupsFolder(CoreBranches.COMMON);
            this.groupArtifact = ArtifactTypeManager.addArtifact(token, CoreBranches.COMMON);
            userGroupsFolder.addChild(this.getArtifact());
        }
        return this.getArtifact();
    }

    private Artifact getOrCreateUserGroupsFolder(BranchToken branch) {
        SkynetTransaction tx = TransactionManager.createTransaction((BranchId)CoreBranches.COMMON, "Create UserGroups Folder");
        Artifact usersGroupFolder = ArtifactQuery.checkArtifactFromId((ArtifactId)CoreArtifactTokens.UserGroups, (BranchId)branch);
        if (usersGroupFolder == null) {
            Artifact root = OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)branch);
            Artifact oseeConfig = ArtifactQuery.checkArtifactFromId((ArtifactId)CoreArtifactTokens.OseeConfiguration, (BranchId)branch);
            if (oseeConfig == null) {
                oseeConfig = ArtifactTypeManager.addArtifact(CoreArtifactTokens.OseeConfiguration);
                root.addChild(oseeConfig);
                tx.addArtifact(oseeConfig);
            }
            usersGroupFolder = ArtifactTypeManager.addArtifact(CoreArtifactTokens.UserGroups, branch);
            usersGroupFolder.persist(tx);
            oseeConfig.addChild(usersGroupFolder);
        }
        return usersGroupFolder;
    }

    public boolean removeMember(UserId user, boolean persist) {
        this.checkGroupExists();
        Artifact userArt = null;
        userArt = user instanceof Artifact ? (Artifact)user : UserManager.getUserByArtId((ArtifactId)user);
        Artifact group = this.getArtifact();
        if (group.isRelated(CoreRelationTypes.Users_User, (ArtifactId)userArt)) {
            group.deleteRelation(CoreRelationTypes.Users_User, userArt);
            if (persist) {
                group.persist("Remove Member");
            }
            return true;
        }
        return false;
    }

    public Collection<UserToken> getMembers() {
        this.checkGroupExists();
        return Collections.castAll(this.getArtifact().getRelatedArtifacts(CoreRelationTypes.Users_User));
    }

    public BranchToken getBranch() {
        return this.groupArtifact.getBranch();
    }
}

