/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import java.io.File;
import java.net.URI;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ExternalHyperlink
implements IHyperlink {
    private File fFile;
    private int fLineNumber;

    public ExternalHyperlink(File file, int lineNumber) {
        this.fFile = file;
        this.fLineNumber = lineNumber;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        block8: {
            FileStoreEditorInput input;
            try {
                IFileStore fileStore = EFS.getStore((URI)this.fFile.toURI());
                input = new FileStoreEditorInput(fileStore);
            }
            catch (CoreException e) {
                AntUIPlugin.log(e);
                return;
            }
            IWorkbenchPage activePage = AntUIPlugin.getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart editorPart = activePage.openEditor((IEditorInput)input, "org.eclipse.ant.ui.internal.editor.AntEditor", true);
                if (this.fLineNumber <= 0 || !(editorPart instanceof ITextEditor)) break block8;
                ITextEditor textEditor = (ITextEditor)editorPart;
                IDocumentProvider provider = textEditor.getDocumentProvider();
                try {
                    provider.connect((Object)input);
                }
                catch (CoreException e) {
                    AntUIPlugin.log(e);
                    return;
                }
                IDocument document = provider.getDocument((Object)input);
                try {
                    IRegion lineRegion = document.getLineInformation(this.fLineNumber);
                    textEditor.selectAndReveal(lineRegion.getOffset(), lineRegion.getLength());
                }
                catch (BadLocationException e) {
                    AntUIPlugin.log(e);
                }
                provider.disconnect((Object)input);
            }
            catch (PartInitException partInitException) {}
        }
    }
}

