/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.task.IAtsTaskService;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsTaskService
implements IAtsTaskService {
    protected final AtsApi atsApi;

    public AbstractAtsTaskService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    @Override
    public Collection<IAtsTask> getTasks(IAtsTeamWorkflow teamWf, IStateToken relatedToState) {
        ArtifactId artifact = this.atsApi.getArtifactResolver().get(teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        for (IAtsTask task : this.atsApi.getRelationResolver().getRelated(teamWf, AtsRelationTypes.TeamWfToTask_Task, IAtsTask.class)) {
            if (!this.atsApi.getAttributeResolver().getSoleAttributeValue(task, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, "").equals(relatedToState.getName())) continue;
            tasks.add(task);
        }
        return tasks;
    }

    @Override
    public Collection<? extends IAtsTask> getTasks(IAtsWorkItem workItem, IStateToken state) {
        ArtifactId artifact = this.atsApi.getArtifactResolver().get(workItem);
        Conditions.checkNotNull((Object)artifact, (String)"workItem", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{workItem.toString()});
        if (workItem instanceof IAtsTeamWorkflow) {
            return this.getTasks((IAtsTeamWorkflow)workItem, state);
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IAtsTask> getTasks(IAtsTeamWorkflow teamWf) {
        ArtifactId artifact = this.atsApi.getArtifactResolver().get(teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        return this.atsApi.getRelationResolver().getRelated(teamWf, AtsRelationTypes.TeamWfToTask_Task, IAtsTask.class);
    }

    @Override
    public Collection<IAtsTask> getTask(IAtsWorkItem workItem) {
        if (workItem.isTeamWorkflow()) {
            return this.getTasks((IAtsTeamWorkflow)workItem);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasTasks(IAtsTeamWorkflow teamWf) {
        return this.atsApi.getRelationResolver().getRelatedCount(teamWf, AtsRelationTypes.TeamWfToTask_Task) > 0;
    }

    @Override
    public boolean isRelatedToState(IAtsTask task, String stateName) {
        return this.atsApi.getAttributeResolver().getSoleAttributeValue(task, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, "").equals(stateName);
    }

    @Override
    public ArtifactId getTaskToRelatedArtifactChanged(IAtsTask task) {
        ArtifactId relatedArt = this.atsApi.getAttributeResolver().getSoleArtifactIdReference(task, (AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, ArtifactId.SENTINEL);
        if (relatedArt.isValid()) {
            IAtsTeamWorkflow parentTeamWf = task.getParentTeamWorkflow();
            ArtifactToken derivedArt = this.atsApi.getRelationResolver().getRelatedOrSentinel(parentTeamWf, AtsRelationTypes.Derive_From);
            if (derivedArt.isValid() && derivedArt instanceof IAtsTeamWorkflow) {
                IAtsTeamWorkflow derivedTeamWf = (IAtsTeamWorkflow)derivedArt;
                if (this.atsApi.getBranchService().isWorkingBranchInWork(derivedTeamWf)) {
                    BranchToken workingBranch = this.atsApi.getBranchService().getWorkingBranch(derivedTeamWf);
                    relatedArt = this.atsApi.getQueryService().getArtifact(relatedArt, BranchId.valueOf((Long)workingBranch.getId()), DeletionFlag.INCLUDE_DELETED);
                } else {
                    TransactionToken earliestTransactionId = this.atsApi.getBranchService().getEarliestTransactionId(derivedTeamWf);
                    if (earliestTransactionId != null) {
                        relatedArt = this.atsApi.getQueryService().getHistoricalArtifactOrNull(relatedArt, earliestTransactionId, DeletionFlag.INCLUDE_DELETED);
                    }
                }
            }
        }
        return relatedArt;
    }

    @Override
    public Collection<IAtsWorkDefinition> calculateTaskWorkDefs(IAtsTeamWorkflow teamWf) {
        Collection workDefIds = this.atsApi.getAttributeResolver().getAttributes(teamWf.getTeamDefinition(), (AttributeTypeToken)AtsAttributeTypes.RelatedTaskWorkflowDefinitionReference);
        ArrayList<IAtsWorkDefinition> workDefs = new ArrayList<IAtsWorkDefinition>();
        for (IAttribute attr : workDefIds) {
            ArtifactId id = (ArtifactId)attr.getValue();
            IAtsWorkDefinition workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)id);
            workDefs.add(workDef);
        }
        return workDefs;
    }

    @Override
    public Collection<CreateTasksDefinitionBuilder> getTaskSets(IAtsTeamWorkflow teamWf) {
        LinkedList<CreateTasksDefinitionBuilder> taskSets = new LinkedList<CreateTasksDefinitionBuilder>();
        for (String idStr : this.atsApi.getAttributeResolver().getAttributesToStringList(teamWf.getTeamDefinition(), (AttributeTypeToken)AtsAttributeTypes.TaskSetId)) {
            CreateTasksDefinitionBuilder taskSet;
            if (!Strings.isValid((String)idStr) || (taskSet = this.atsApi.getTaskSetDefinitionProviderService().getTaskSetDefinition(Long.valueOf(idStr))) == null) continue;
            taskSets.add(taskSet);
        }
        return taskSets;
    }
}

