/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.osee.framework.ui.swt.FormattedText;
import org.eclipse.swt.custom.StyledText;

public class FormattedTextOutputStream
extends OutputStream {
    private final FormattedText textArea;
    private String charset;
    private final StyledText styledText;
    private final String type;
    private int swtColor;

    public FormattedTextOutputStream(FormattedText textArea, String type) {
        this.textArea = textArea;
        this.styledText = textArea.getStyledText();
        this.charset = null;
        this.type = type;
    }

    public FormattedTextOutputStream(FormattedText ta, String charset, String type) throws UnsupportedCharsetException {
        this(ta, type);
        Charset.forName(charset);
        this.charset = charset;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    private boolean isTextAreaAvailable() {
        return this.textArea != null && !this.textArea.getStyledText().isDisposed();
    }

    public void typeColor(int swtColor) {
        this.swtColor = swtColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) {
        String s;
        try {
            s = this.charset == null ? new String(b, off, len) : new String(b, off, len, this.charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error("encoding support was already verified", ex);
        }
        FormattedText formattedText = this.textArea;
        synchronized (formattedText) {
            if (this.isTextAreaAvailable()) {
                this.textArea.addText("\t" + this.type + "> ", 1, this.swtColor);
                this.textArea.addText(String.valueOf(s) + "\n");
                this.styledText.setSelection(this.styledText.getCharCount());
            }
        }
    }

    @Override
    public void write(int b) {
        byte[] tmp = new byte[]{(byte)b};
        this.write(tmp);
    }
}

