/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.ParticipantDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class ProcessorBasedRefactoring
extends Refactoring {
    private static final String PERF_CHECK_CONDITIONS = "org.eclipse.ltk.core.refactoring/perf/participants/checkConditions";
    private static final String PERF_CREATE_CHANGES = "org.eclipse.ltk.core.refactoring/perf/participants/createChanges";
    private RefactoringProcessor fProcessor;
    private List<RefactoringParticipant> fParticipants;
    private List<RefactoringParticipant> fPreChangeParticipants;
    private Map<Object, TextChange> fTextChangeMap;
    private static final List<RefactoringParticipant> EMPTY_PARTICIPANTS = Collections.emptyList();

    @Deprecated
    protected ProcessorBasedRefactoring() {
    }

    public ProcessorBasedRefactoring(RefactoringProcessor processor) {
        this.setProcessor(processor);
    }

    public RefactoringProcessor getProcessor() {
        return this.fProcessor;
    }

    public void setProcessor(RefactoringProcessor processor) {
        processor.setRefactoring(this);
        this.fProcessor = processor;
    }

    public final boolean isApplicable() throws CoreException {
        return this.getProcessor().isApplicable();
    }

    @Override
    public String getName() {
        return this.getProcessor().getProcessorName();
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 10);
        pm.setTaskName(RefactoringCoreMessages.ProcessorBasedRefactoring_initial_conditions);
        result.merge(this.getProcessor().checkInitialConditions((IProgressMonitor)new SubProgressMonitor(pm, 8)));
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        pm.done();
        return result;
    }

    @Override
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        CheckConditionsContext context = this.createCheckConditionsContext();
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.ProcessorBasedRefactoring_final_conditions);
        result.merge(this.getProcessor().checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 5), context));
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        SharableParticipants sharableParticipants = new SharableParticipants();
        RefactoringParticipant[] loadedParticipants = this.getProcessor().loadParticipants(result, sharableParticipants);
        if (loadedParticipants == null || loadedParticipants.length == 0) {
            this.fParticipants = EMPTY_PARTICIPANTS;
        } else {
            this.fParticipants = new ArrayList<RefactoringParticipant>();
            this.fParticipants.addAll(Arrays.asList(loadedParticipants));
        }
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        SubProgressMonitor sm = new SubProgressMonitor(pm, 2);
        sm.beginTask("", this.fParticipants.size());
        Iterator<RefactoringParticipant> iter = this.fParticipants.iterator();
        while (iter.hasNext() && !result.hasFatalError()) {
            RefactoringParticipant participant = iter.next();
            PerformanceStats stats = PerformanceStats.getStats((String)PERF_CHECK_CONDITIONS, (Object)(String.valueOf(this.getName()) + ", " + participant.getName()));
            stats.startRun();
            try {
                result.merge(participant.checkConditions((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sm, 1), context));
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException e) {
                RefactoringCorePlugin.log(e);
                result.merge(RefactoringStatus.createErrorStatus(Messages.format(RefactoringCoreMessages.ProcessorBasedRefactoring_check_condition_participant_failed, participant.getName())));
                iter.remove();
            }
            stats.endRun();
            if (!sm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        sm.done();
        if (result.hasFatalError()) {
            pm.done();
            return result;
        }
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", this.fParticipants.size() + 3);
        pm.setTaskName(RefactoringCoreMessages.ProcessorBasedRefactoring_create_change);
        Change processorChange = this.getProcessor().createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.fTextChangeMap = new HashMap<Object, TextChange>();
        this.addToTextChangeMap(processorChange);
        ArrayList<Change> changes = new ArrayList<Change>();
        ArrayList<Change> preChanges = new ArrayList<Change>();
        HashMap<Change, RefactoringParticipant> participantMap = new HashMap<Change, RefactoringParticipant>();
        for (RefactoringParticipant participant : this.fParticipants) {
            try {
                PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_CHANGES, (Object)(String.valueOf(this.getName()) + ", " + participant.getName()));
                stats.startRun();
                Change preChange = participant.createPreChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                Change change = participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
                stats.endRun();
                if (preChange != null) {
                    if (this.fPreChangeParticipants == null) {
                        this.fPreChangeParticipants = new ArrayList<RefactoringParticipant>();
                    }
                    this.fPreChangeParticipants.add(participant);
                    preChanges.add(preChange);
                    participantMap.put(preChange, participant);
                    this.addToTextChangeMap(preChange);
                }
                if (change != null) {
                    changes.add(change);
                    participantMap.put(change, participant);
                    this.addToTextChangeMap(change);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (RuntimeException | CoreException e) {
                ProcessorBasedRefactoring.disableParticipant(participant, e);
                throw e;
            }
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        this.fTextChangeMap = null;
        Change postChange = this.getProcessor().postCreateChange(changes.toArray(new Change[changes.size()]), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ProcessorChange result = new ProcessorChange(this.getName());
        result.addAll(preChanges.toArray(new Change[preChanges.size()]));
        result.add(processorChange);
        result.addAll(changes.toArray(new Change[changes.size()]));
        result.setParticipantMap(participantMap);
        result.setPreChangeParticipants(this.fPreChangeParticipants);
        if (postChange != null) {
            result.add(postChange);
        }
        return result;
    }

    public TextChange getTextChange(Object element) {
        if (this.fTextChangeMap == null) {
            return null;
        }
        return this.fTextChangeMap.get(element);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        RefactoringProcessor processor = this.getProcessor();
        if (clazz.isInstance((Object)processor)) {
            return (T)((Object)processor);
        }
        return super.getAdapter(clazz);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private CheckConditionsContext createCheckConditionsContext() throws CoreException {
        CheckConditionsContext result = new CheckConditionsContext();
        result.add(new ValidateEditChecker(this.getValidationContext()));
        result.add(new ResourceChangeChecker());
        return result;
    }

    private static void disableParticipant(RefactoringParticipant participant, Throwable e) {
        ParticipantDescriptor descriptor = participant.getDescriptor();
        descriptor.disable();
        RefactoringCorePlugin.logRemovedParticipant(descriptor, e);
    }

    private void addToTextChangeMap(Change change) {
        if (change instanceof TextChange) {
            Object element = ((TextChange)change).getModifiedElement();
            if (element != null) {
                this.fTextChangeMap.put(element, (TextChange)change);
            }
            if (change instanceof TextFileChange && !change.getClass().equals(TextFileChange.class)) {
                TextFileChange textFileChange = (TextFileChange)change;
                IFile file = textFileChange.getFile();
                this.fTextChangeMap.put(file, textFileChange);
            }
        } else if (change instanceof CompositeChange) {
            Change[] children;
            Change[] changeArray = children = ((CompositeChange)change).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Change child = changeArray[n2];
                this.addToTextChangeMap(child);
                ++n2;
            }
        }
    }

    private static class ProcessorChange
    extends CompositeChange {
        private Map<Change, RefactoringParticipant> fParticipantMap;
        private List<RefactoringParticipant> fPreChangeParticipants;

        public ProcessorChange(String name) {
            super(name);
            this.markAsSynthetic();
        }

        public void setParticipantMap(Map<Change, RefactoringParticipant> map) {
            this.fParticipantMap = map;
        }

        public void setPreChangeParticipants(List<RefactoringParticipant> list) {
            this.fPreChangeParticipants = list;
        }

        @Override
        protected void internalHandleException(Change change, Throwable e) {
            if (e instanceof OperationCanceledException) {
                return;
            }
            RefactoringParticipant participant2 = this.fParticipantMap.get(change);
            if (participant2 != null) {
                ProcessorBasedRefactoring.disableParticipant(participant2, e);
            } else if (this.fPreChangeParticipants != null) {
                Status status = new Status(4, RefactoringCorePlugin.getPluginId(), 10008, RefactoringCoreMessages.ProcessorBasedRefactoring_prechange_participants_removed, e);
                ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                for (RefactoringParticipant participant2 : this.fPreChangeParticipants) {
                    ProcessorBasedRefactoring.disableParticipant(participant2, null);
                }
            }
        }

        @Override
        protected boolean internalContinueOnCancel() {
            return true;
        }

        @Override
        protected boolean internalProcessOnCancel(Change change) {
            RefactoringParticipant participant = this.fParticipantMap.get(change);
            if (participant == null) {
                return false;
            }
            return participant.getDescriptor().processOnCancel();
        }
    }
}

