/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class DateIterator
implements Iterator<Calendar>,
Cloneable {
    private final Calendar startCal;
    private final Calendar endCal;
    private final int intervalField;
    private final int intervalQty;
    private final boolean normalize;
    private final int calendarFieldToNormalize;
    private final int calendarFieldValueToNormalizeOn;
    private Calendar currentCalIndex = null;

    public DateIterator(Calendar startCal, Calendar endCal) {
        this(startCal.getTime(), endCal.getTime(), 5, 1);
    }

    public DateIterator(Date startDate, Date endDate) {
        this(startDate, endDate, 5, 1);
    }

    public DateIterator(Calendar startCal, Calendar endCal, int intervalField, int intervalQty) {
        this(startCal.getTime(), endCal.getTime(), intervalField, intervalQty);
    }

    public DateIterator(Date startDate, Date endDate, int intervalField, int intervalQty) {
        this(startDate, endDate, intervalField, intervalQty, false, 0, 0);
    }

    public DateIterator(Calendar startCal, Calendar endCal, int intervalField, int intervalQty, boolean normalize, int calendarFieldToNormalize, int calendarFieldValueToNormalizeOn) {
        this(startCal.getTime(), endCal.getTime(), intervalField, intervalQty, normalize, calendarFieldToNormalize, calendarFieldValueToNormalizeOn);
    }

    public DateIterator(Date startDate, Date endDate, int intervalField, int intervalQty, boolean normalize, int calendarFieldToNormalize, int calendarFieldValueToNormalizeOn) {
        Calendar sCal = Calendar.getInstance();
        Calendar eCal = Calendar.getInstance();
        sCal.setTime(startDate);
        eCal.setTime(endDate);
        this.startCal = sCal;
        this.endCal = eCal;
        this.intervalField = intervalField;
        this.intervalQty = intervalQty;
        this.normalize = normalize;
        this.calendarFieldToNormalize = calendarFieldToNormalize;
        this.calendarFieldValueToNormalizeOn = calendarFieldValueToNormalizeOn;
        this.resetIterator();
    }

    public void resetIterator() {
        this.currentCalIndex = this.getFirstIteration();
    }

    @Override
    public boolean hasNext() {
        return this.currentCalIndex != null;
    }

    @Override
    public Calendar next() {
        if (this.currentCalIndex == null) {
            return null;
        }
        Calendar retCal = (Calendar)this.currentCalIndex.clone();
        if (this.currentCalIndex.compareTo(this.endCal) >= 0) {
            this.currentCalIndex = null;
        } else {
            this.currentCalIndex.add(this.intervalField, this.intervalQty);
        }
        return retCal;
    }

    @Override
    public void remove() {
    }

    public int getManyIterations() {
        int manyIters = 0;
        DateIterator di = (DateIterator)this.clone();
        while (di.hasNext()) {
            di.next();
            ++manyIters;
        }
        return manyIters;
    }

    public int getIterationOfCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int manyIters = 0;
        DateIterator di = (DateIterator)this.clone();
        Calendar curCal = (Calendar)this.startCal.clone();
        while (di.hasNext() && curCal.before(calendar)) {
            curCal = di.next();
            ++manyIters;
        }
        return manyIters;
    }

    public Calendar getFirstIteration() {
        Calendar cal = (Calendar)this.startCal.clone();
        if (this.normalize) {
            while (cal.get(this.calendarFieldToNormalize) != this.calendarFieldValueToNormalizeOn) {
                cal.add(5, -1);
            }
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public Calendar getLastIteration() {
        DateIterator di = new DateIterator(this.startCal, this.endCal, this.intervalField, this.intervalQty);
        Calendar cal = (Calendar)this.startCal.clone();
        while (di.hasNext()) {
            cal = di.next();
        }
        return cal;
    }

    public Date getNormalizedDate(Date unNormalDate) {
        DateIterator di = (DateIterator)this.clone();
        Date normalDate = di.next().getTime();
        while (di.hasNext() && normalDate.before(unNormalDate)) {
            normalDate = di.next().getTime();
        }
        return normalDate;
    }

    public List<Date> getAllDates() {
        ArrayList<Date> allDates = new ArrayList<Date>();
        DateIterator di = (DateIterator)this.clone();
        while (di.hasNext()) {
            Calendar calendar = di.next();
            allDates.add(calendar.getTime());
        }
        return allDates;
    }

    protected Object clone() {
        DateIterator cloneDI = new DateIterator((Calendar)this.startCal.clone(), (Calendar)this.endCal.clone(), this.intervalField, this.intervalQty, this.normalize, this.calendarFieldToNormalize, this.calendarFieldValueToNormalizeOn);
        return cloneDI;
    }
}

