/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.OseeSystemArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public final class HierarchyHandler {
    private static final Matcher subsystemMatcher = Pattern.compile("(\\w*)\\.ss").matcher("");
    private final Map<String, Artifact> folderNameToArtifact = new HashMap<String, Artifact>(50);
    private final SkynetTransaction transaction;
    private final BranchToken branch;
    private Artifact root;

    public HierarchyHandler(SkynetTransaction transaction) {
        this.transaction = transaction;
        this.branch = BranchManager.getBranchToken((BranchId)transaction.getBranch());
    }

    public void addArtifact(Artifact testUnit) {
        Conditions.checkExpressionFailOnTrue((!testUnit.isOnBranch((BranchId)this.branch) ? 1 : 0) != 0, (String)"Artifact [%s] must be on branch [%s]", (Object[])new Object[]{testUnit.toString(), this.branch.getId()});
        Artifact folder = null;
        folder = testUnit.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.TestCase}) ? this.getOrCreateTestCaseFolder() : (testUnit.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.TestSupport}) ? this.getOrCreateTestSupportFolder() : (testUnit.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.CodeUnit}) ? this.getOrCreateCodeUnitFolder(testUnit.getName()) : this.getOrCreateUnknownTestUnitFolder()));
        this.addChildIfNotRelated(folder, testUnit);
    }

    private Artifact getOrCreateUnknownTestUnitFolder() {
        return this.getOrCreateTestUnitsFolder("Unknown Test Unit Type", true);
    }

    private Artifact getOrCreateTestSupportFolder() {
        return this.getOrCreateTestUnitsFolder(CoreArtifactTokens.TestSupportUnitsFolder.getName(), true);
    }

    private Artifact getOrCreateTestCaseFolder() {
        return this.getOrCreateTestUnitsFolder("Test Cases", true);
    }

    private Artifact getRoot() {
        if (this.root == null) {
            this.root = OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)this.branch);
        }
        return this.root;
    }

    private Artifact getOrCreateCodeUnitFolder(String codeUnitName) {
        Artifact root = this.getRoot();
        Artifact toReturn = this.getOrCreateFolder("Code Units", root);
        subsystemMatcher.reset(codeUnitName);
        if (subsystemMatcher.find()) {
            String subSystem = subsystemMatcher.group(1);
            subSystem = subSystem.toUpperCase();
            toReturn = this.getOrCreateFolder(subSystem, toReturn);
        }
        return toReturn;
    }

    private Artifact getOrCreateTestUnitsFolder(String subfolderName, boolean includesSubfolder) {
        Artifact root = this.getRoot();
        Artifact testFolder = this.getOrCreateFolder("Test", root);
        Artifact testUnitFolder = this.getOrCreateFolder("Test Units", testFolder);
        if (subfolderName != null && includesSubfolder) {
            Artifact subFolder = this.getOrCreateFolder(subfolderName, testUnitFolder);
            return subFolder;
        }
        return testUnitFolder;
    }

    private void persistHelper(Artifact toPersist) {
        if (this.transaction != null) {
            toPersist.persist(this.transaction);
        }
    }

    private void addChildIfNotRelated(Artifact parentFolder, Artifact childFolder) {
        boolean related = parentFolder.isRelated(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)childFolder);
        if (!related) {
            parentFolder.addChild(childFolder);
            this.persistHelper(parentFolder);
        }
    }

    private Artifact getOrCreateFolder(String folderName, Artifact parentFolder) {
        Artifact toReturn = this.folderNameToArtifact.get(folderName);
        if (toReturn == null) {
            List relatedFolders = ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Folder, (String)folderName, (BranchId)this.branch);
            if (relatedFolders.size() == 1) {
                toReturn = (Artifact)relatedFolders.iterator().next();
            } else if (relatedFolders.size() > 1) {
                for (Artifact folder : relatedFolders) {
                    if (!parentFolder.isRelated(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)folder)) continue;
                    toReturn = folder;
                    break;
                }
            }
            if (toReturn == null) {
                toReturn = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.Folder, (BranchToken)this.branch, (String)folderName);
                parentFolder.addChild(toReturn);
                toReturn.persist(this.transaction);
            }
            this.folderNameToArtifact.put(folderName, toReturn);
        }
        return toReturn;
    }
}

