/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.errorhandler;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.define.ide.errorhandler.Resolver;
import org.eclipse.osee.define.ide.errorhandler.StateValue;

public class ErrorHandler {
    private final Set<Resolver> set = new HashSet<Resolver>();
    private final StateValue value = new StateValue();

    public void processException(Exception ex) {
        boolean resolved = false;
        for (Resolver r : this.set) {
            if (!r.resolve(ex, this.value)) continue;
            resolved = true;
        }
        if (!resolved) {
            throw new RuntimeException("Exception not resolved", ex);
        }
    }

    public void addResolver(Resolver resolver) {
        this.set.add(resolver);
    }

    public boolean isSaveValid() {
        return this.value.isSaveValid();
    }
}

