/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.osee.framework.ui.swt.CustomTableCellEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public abstract class TextCellEditor
extends CustomTableCellEditor<String> {
    private final TableEditor editor;
    private final Table table;
    private final int columnIndex;
    private final int textStyle;
    private final String toolTip;
    private boolean enabled;
    private final EditCellListener tblListener;

    public TextCellEditor(Table table, int columnIndex, int textStyle, String toolTip) {
        this.table = table;
        this.columnIndex = columnIndex;
        this.textStyle = textStyle;
        this.toolTip = toolTip;
        this.enabled = true;
        this.editor = new TableEditor(table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.tblListener = new EditCellListener();
        table.addListener(3, (Listener)this.tblListener);
    }

    @Override
    protected abstract String applyValue(int var1, String var2, String var3);

    @Override
    protected abstract String focusLost(int var1, String var2, String var3);

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        if (enabled) {
            this.table.addListener(3, (Listener)this.tblListener);
            this.enabled = true;
        } else {
            this.table.removeListener(3, (Listener)this.tblListener);
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private final class EditCellListener
    implements Listener {
        private EditCellListener() {
        }

        public void handleEvent(Event event) {
            Point pt = new Point(event.x, event.y);
            int index = TextCellEditor.this.table.getTopIndex();
            while (index < TextCellEditor.this.table.getItemCount()) {
                if (!TextCellEditor.this.doNotEditList.get(index)) {
                    final int rowIndex = index;
                    final TableItem item = TextCellEditor.this.table.getItem(index);
                    Rectangle rect = item.getBounds(TextCellEditor.this.columnIndex);
                    if (rect.contains(pt)) {
                        final String oldText = item.getText(TextCellEditor.this.columnIndex);
                        final Text text = new Text((Composite)TextCellEditor.this.table, TextCellEditor.this.textStyle);
                        text.setToolTipText(TextCellEditor.this.toolTip);
                        Listener textListener = new Listener(){

                            public void handleEvent(Event e) {
                                String value = text.getText();
                                switch (e.type) {
                                    case 16: {
                                        item.setText(((EditCellListener)EditCellListener.this).TextCellEditor.this.columnIndex, TextCellEditor.this.focusLost(rowIndex, value, oldText));
                                        text.dispose();
                                        break;
                                    }
                                    case 31: {
                                        switch (e.detail) {
                                            case 4: {
                                                item.setText(((EditCellListener)EditCellListener.this).TextCellEditor.this.columnIndex, TextCellEditor.this.applyValue(rowIndex, value, oldText));
                                            }
                                            case 2: {
                                                text.dispose();
                                                e.doit = false;
                                            }
                                        }
                                    }
                                }
                            }
                        };
                        text.addListener(16, textListener);
                        text.addListener(31, textListener);
                        TextCellEditor.this.editor.setEditor((Control)text, item, TextCellEditor.this.columnIndex);
                        text.setText(oldText);
                        text.selectAll();
                        text.setFocus();
                        return;
                    }
                }
                ++index;
            }
        }
    }
}

