/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.actions.AddTaskAction;
import org.eclipse.osee.ats.ide.actions.DeleteTasksAction;
import org.eclipse.osee.ats.ide.actions.IAtsTaskArtifactProvider;
import org.eclipse.osee.ats.ide.actions.NewAction;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsTaskEditorAction;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsTaskEditorSelected;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsWorldEditorAction;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsWorldEditorSelectedAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalManager;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.ReviewManager;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskComposite;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.IWorldEditorParameterProvider;
import org.eclipse.osee.ats.ide.world.WorkflowMetricsUI;
import org.eclipse.osee.ats.ide.world.WorldAssigneeFilter;
import org.eclipse.osee.ats.ide.world.WorldCompletedFilter;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.XFormToolkit;
import org.eclipse.osee.framework.ui.skynet.XWidgetParser;
import org.eclipse.osee.framework.ui.skynet.action.CollapseAllAction;
import org.eclipse.osee.framework.ui.skynet.action.ExpandAllAction;
import org.eclipse.osee.framework.ui.skynet.action.RefreshAction;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionUtility;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.skynet.widgets.util.DefaultXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class WorldXWidgetActionPage
extends FormPage {
    protected SwtXWidgetRenderer dynamicXWidgetLayout;
    protected final XFormToolkit toolkit;
    private Composite parametersContainer;
    private Section parameterSection;
    protected Composite resultsContainer;
    protected Section resultsSection;
    protected ScrolledForm scrolledForm;
    private String title;
    private String xWidgetXml;
    public static final String ID = "org.eclipse.osee.ats.ide.actionPage";
    public static final String MENU_GROUP_PRE = "world.menu.group.pre";
    private final WorldEditor worldEditor;
    private WorldComposite worldComposite;
    private static Action filterCompletedAction;
    private static Action filterMyAssigneeAction;
    private static Action toAction;
    private static Action toGoal;
    private static Action toReview;
    private static Action toWorkFlow;
    private static Action toTask;
    private final WorldCompletedFilter worldCompletedFilter = new WorldCompletedFilter();
    private WorldAssigneeFilter worldAssigneeFilter = null;
    private WorkflowMetricsUI workflowMetricsUi;
    private final String ACTIONS = "Re-display as Actions";
    private final String GOALS = "Re-display as Goals";
    private final String WORKFLOWS = "Re-display as WorkFlows";
    private final String TASKS = "Re-display as Tasks";
    private final String REVIEWS = "Re-display as Reviews";

    public WorldXWidgetActionPage(WorldEditor worldEditor) {
        super((FormEditor)worldEditor, ID, worldEditor.isTaskEditor() ? "Tasks" : "Actions");
        this.toolkit = new XFormToolkit();
        this.worldEditor = worldEditor;
    }

    public WorldComposite getWorldComposite() {
        return this.worldComposite;
    }

    public Result isResearchSearchValid() {
        return this.worldEditor.isDirty() ? new Result("Changes un-saved. Save first.") : Result.TrueResult;
    }

    public String getXWidgetsXml() {
        if (this.worldEditor.getWorldEditorProvider() instanceof IWorldEditorParameterProvider) {
            return ((IWorldEditorParameterProvider)this.worldEditor.getWorldEditorProvider()).getParameterXWidgetXml();
        }
        return null;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setImage(ImageManager.getImage((OseeImage)AtsImage.GLOBE));
        this.setPartName(this.getTabName());
        Result result = DbConnectionUtility.areOSEEServicesAvailable();
        if (result.isFalse()) {
            AWorkbench.popup((String)"ERROR", (String)"Database Unavailable");
            return;
        }
        FormsUtil.addHeadingGradient((FormToolkit)this.toolkit, (ScrolledForm)this.scrolledForm, (boolean)true);
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)true));
        body.setLayoutData((Object)new GridData(16384, 16384, false, false));
        this.xWidgetXml = this.getXWidgetsXml();
        try {
            if (Strings.isValid((String)this.xWidgetXml)) {
                managedForm.addPart((IFormPart)new SectionPart(this.createParametersSection(managedForm, body)));
            }
            managedForm.addPart((IFormPart)new SectionPart(this.createResultsSection(body)));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        XWidgetUtility.setLabelFontsBold((Control)body, (Font)FontManager.getDefaultLabelFont());
        this.createToolBar();
        managedForm.refresh();
        try {
            this.worldEditor.getWorldEditorProvider().run(this.worldEditor, WorldSearchItem.SearchType.Search, false);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private void createToolBar() {
        IToolBarManager toolBarManager = this.scrolledForm.getToolBarManager();
        this.createToolBar(toolBarManager);
        this.scrolledForm.updateToolBar();
    }

    public void reflow() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IManagedForm manager = WorldXWidgetActionPage.this.getManagedForm();
                if (manager != null && Widgets.isAccessible((Widget)manager.getForm())) {
                    WorldXWidgetActionPage.this.getManagedForm().reflow(true);
                }
            }
        });
    }

    private Section createParametersSection(IManagedForm managedForm, Composite body) {
        this.parameterSection = this.toolkit.createSection(body, 2);
        this.parameterSection.setText("Parameters");
        this.parameterSection.setLayoutData((Object)new GridData(768));
        this.parametersContainer = this.toolkit.createClientContainer(this.parameterSection, 1);
        this.parameterSection.setExpanded(true);
        Composite mainComp = this.toolkit.createComposite(this.parametersContainer, 0);
        mainComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)3, (boolean)false));
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createButtonCompositeOnLeft(mainComp);
        this.createSearchParametersOnRight(managedForm, mainComp);
        this.createParametersSectionCompleted(managedForm, mainComp);
        return this.parameterSection;
    }

    public void createSearchParametersOnRight(IManagedForm managedForm, Composite mainComp) {
        Composite paramComp = new Composite(mainComp, 0);
        paramComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        paramComp.setLayoutData((Object)new GridData(4, 4, true, true));
        List layoutDatas = null;
        this.dynamicXWidgetLayout = new SwtXWidgetRenderer(this.getDynamicWidgetLayoutListener(), this.getXWidgetOptionResolver());
        try {
            layoutDatas = XWidgetParser.extractWorkAttributes((SwtXWidgetRenderer)this.dynamicXWidgetLayout, (String)this.xWidgetXml);
            if (layoutDatas != null && !layoutDatas.isEmpty()) {
                this.dynamicXWidgetLayout.addWorkLayoutDatas(layoutDatas);
                this.dynamicXWidgetLayout.createBody(managedForm, paramComp, null, null, true);
                this.parametersContainer.layout();
                this.parametersContainer.getParent().layout();
            }
            this.parameterSection.setExpanded(true);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void createButtonCompositeOnLeft(Composite mainComp) {
        Composite buttonComp = this.toolkit.createComposite(mainComp, 0);
        buttonComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        buttonComp.setLayoutData((Object)new GridData(0, 1024, false, true));
        Button searchButton = this.toolkit.createButton(buttonComp, "Search", 8);
        GridData gridData = new GridData(4, 1024, true, true);
        searchButton.setLayoutData((Object)gridData);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorldXWidgetActionPage.this.handleSearchButtonPressed();
            }
        });
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            Button search2Button = this.toolkit.createButton(buttonComp, "Search-2 (Beta)", 8);
            gridData = new GridData(4, 1024, true, true);
            search2Button.setLayoutData((Object)gridData);
            search2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WorldXWidgetActionPage.this.handleSearch2ButtonPressed();
                }
            });
        }
        buttonComp.layout();
    }

    public IDynamicWidgetLayoutListener getDynamicWidgetLayoutListener() {
        if (this.worldEditor.getWorldEditorProvider() instanceof IWorldEditorParameterProvider) {
            return ((IWorldEditorParameterProvider)this.worldEditor.getWorldEditorProvider()).getDynamicWidgetLayoutListener();
        }
        return null;
    }

    public void reSearch() {
        Result result = this.isResearchSearchValid();
        if (result.isFalse()) {
            AWorkbench.popup((Result)result);
            return;
        }
        this.reSearch(false);
    }

    public void reSearch2() {
        Result result = this.isResearchSearchValid();
        if (result.isFalse()) {
            AWorkbench.popup((Result)result);
            return;
        }
        this.reSearch2(false);
    }

    public IXWidgetOptionResolver getXWidgetOptionResolver() {
        return new DefaultXWidgetOptionResolver();
    }

    public void handleSearchButtonPressed() {
        try {
            this.reSearch();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void handleSearch2ButtonPressed() {
        try {
            this.reSearch2();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void reSearch(boolean forcePend) {
        this.worldEditor.getWorldEditorProvider().run(this.worldEditor, WorldSearchItem.SearchType.ReSearch, forcePend);
    }

    public void reSearch2(boolean forcePend) {
        this.worldEditor.getWorldEditorProvider().run(this.worldEditor, WorldSearchItem.SearchType.ReSearch, forcePend, true);
    }

    public void setTableTitle(final String title, boolean warning) {
        this.title = Strings.truncate((String)title, (int)80);
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)WorldXWidgetActionPage.this.scrolledForm)) {
                    WorldXWidgetActionPage.this.scrolledForm.setText(title);
                }
            }
        });
    }

    public Section createResultsSection(Composite body) {
        this.resultsSection = this.toolkit.createSection(body, 4096);
        this.resultsSection.setLayoutData((Object)new GridData(1808));
        this.resultsContainer = this.toolkit.createClientContainer(this.resultsSection, 1);
        this.worldComposite = new WorldComposite(this.worldEditor, this.resultsContainer, 2064);
        this.worldComposite.setLayout((Layout)ALayout.getZeroMarginLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 100;
        gd.heightHint = 100;
        this.worldComposite.setLayoutData(gd);
        this.workflowMetricsUi = new WorkflowMetricsUI(this.worldComposite, this.toolkit);
        this.toolkit.adapt((Composite)this.worldComposite);
        return this.resultsSection;
    }

    public ScrolledForm getScrolledForm() {
        return this.scrolledForm;
    }

    public String getCurrentTitleLabel() {
        String useTitle = "World Editor";
        if (this.title != null) {
            useTitle = this.title;
        }
        return Strings.truncate((String)useTitle, (int)80);
    }

    private String getTabName() {
        String name = "Tasks";
        try {
            if (this.getTaskComposite() != null) {
                TeamWorkFlowArtifact teamArt = this.getTaskComposite().getTeamArt();
                name = String.format("Tasks (%d)", AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)teamArt).size());
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return name;
    }

    protected void createToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new GroupMarker(MENU_GROUP_PRE));
        if (this.worldEditor.isTaskEditor()) {
            try {
                final TaskComposite taskComposite = this.getTaskComposite();
                if (taskComposite != null && taskComposite.getIXTaskViewer().isTasksEditable()) {
                    toolBarManager.add((IAction)new AddTaskAction(this.worldComposite));
                    IAtsTaskArtifactProvider taskProvider = new IAtsTaskArtifactProvider(){

                        @Override
                        public List<TaskArtifact> getSelectedArtifacts() {
                            return taskComposite.getSelectedTaskArtifacts();
                        }
                    };
                    toolBarManager.add((IAction)new DeleteTasksAction(taskProvider));
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.worldComposite.getXViewer().getCustomizeAction());
        toolBarManager.add((IContributionItem)new Separator());
        if (this.worldEditor.isTaskEditor()) {
            toolBarManager.add((IAction)new OpenNewAtsTaskEditorAction(this.worldComposite));
            toolBarManager.add((IAction)new OpenNewAtsTaskEditorSelected(this.worldComposite));
        } else {
            toolBarManager.add((IAction)new OpenNewAtsWorldEditorAction(this.worldComposite));
            toolBarManager.add((IAction)new OpenNewAtsWorldEditorSelectedAction(this.worldComposite));
        }
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new ExpandAllAction((TreeViewer)this.worldComposite.getXViewer()));
        toolBarManager.add((IAction)new CollapseAllAction((TreeViewer)this.worldComposite.getXViewer()));
        toolBarManager.add((IAction)new RefreshAction((RefreshAction.IRefreshActionHandler)this.worldComposite));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new NewAction());
        toolBarManager.add((IContributionItem)new Separator());
        this.createDropDownMenuActions();
        toolBarManager.add((IAction)new DropDownAction());
        try {
            if (this.worldEditor.getWorldEditorProvider() instanceof IWorldEditorParameterProvider) {
                ((IWorldEditorParameterProvider)this.worldEditor.getWorldEditorProvider()).createToolbar(toolBarManager);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private TaskComposite getTaskComposite() {
        TaskComposite taskComposite = null;
        if (this.worldComposite instanceof TaskComposite) {
            taskComposite = (TaskComposite)this.worldComposite;
        }
        return taskComposite;
    }

    protected void createDropDownMenuActions() {
        try {
            this.worldAssigneeFilter = new WorldAssigneeFilter();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        this.workflowMetricsUi.getOrCreateAction();
        filterCompletedAction = new Action("Filter Out Completed/Cancelled - Ctrl-F", 2){

            public void run() {
                if (filterCompletedAction.isChecked()) {
                    WorldXWidgetActionPage.this.worldComposite.getXViewer().addFilter(WorldXWidgetActionPage.this.worldCompletedFilter);
                } else {
                    WorldXWidgetActionPage.this.worldComposite.getXViewer().removeFilter(WorldXWidgetActionPage.this.worldCompletedFilter);
                }
                WorldXWidgetActionPage.this.updateExtendedStatusString();
                WorldXWidgetActionPage.this.worldComposite.getXViewer().refresh();
            }
        };
        filterCompletedAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GREEN_PLUS));
        filterMyAssigneeAction = new Action("Filter My Assignee - Ctrl-G", 2){

            public void run() {
                if (filterMyAssigneeAction.isChecked()) {
                    WorldXWidgetActionPage.this.worldComposite.getXViewer().addFilter(WorldXWidgetActionPage.this.worldAssigneeFilter);
                } else {
                    WorldXWidgetActionPage.this.worldComposite.getXViewer().removeFilter(WorldXWidgetActionPage.this.worldAssigneeFilter);
                }
                WorldXWidgetActionPage.this.updateExtendedStatusString();
                WorldXWidgetActionPage.this.worldComposite.getXViewer().refresh();
            }
        };
        filterMyAssigneeAction.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.USER));
        toAction = new Action("Re-display as Actions", 1){

            public void run() {
                WorldXWidgetActionPage.this.redisplayAsAction();
            }
        };
        toAction.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.ACTION));
        toGoal = new Action("Re-display as Goals", 1){

            public void run() {
                WorldXWidgetActionPage.this.redisplayAsGoals();
            }
        };
        toGoal.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.GOAL));
        toWorkFlow = new Action("Re-display as WorkFlows", 1){

            public void run() {
                WorldXWidgetActionPage.this.redisplayAsWorkFlow();
            }
        };
        toWorkFlow.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.WORKFLOW));
        toTask = new Action("Re-display as Tasks", 1){

            public void run() {
                WorldXWidgetActionPage.this.redisplayAsTask();
            }
        };
        toTask.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.TASK));
        toReview = new Action("Re-display as Reviews", 1){

            public void run() {
                WorldXWidgetActionPage.this.redisplayAsReviews();
            }
        };
        toReview.setImageDescriptor(ImageManager.getImageDescriptor((OseeImage)AtsImage.REVIEW));
    }

    public void redisplayAsAction() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Re-display as Actions"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<Artifact> arts = new HashSet<Artifact>();
                    for (Artifact art : artifacts) {
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            arts.add(art);
                            continue;
                        }
                        if (!(art instanceof AbstractWorkflowArtifact)) continue;
                        Artifact parentArt = null;
                        IAtsAction action = ((AbstractWorkflowArtifact)art).getParentAction();
                        if (action != null) {
                            parentArt = (Artifact)action.getStoreObject();
                        }
                        if (parentArt == null) continue;
                        arts.add(parentArt);
                    }
                    if (arts.isEmpty()) {
                        AWorkbench.popup((String)"No Actions to Display");
                    } else {
                        WorldXWidgetActionPage.this.worldComposite.load(WorldXWidgetActionPage.this.worldEditor.getWorldXWidgetActionPage().getCurrentTitleLabel(), arts, new XNavigateComposite.TableLoadOption[0]);
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void redisplayAsGoals() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Re-display as Goals"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<Artifact> goals = new HashSet<Artifact>();
                    new GoalManager().getCollectors(artifacts, goals, true);
                    if (goals.isEmpty()) {
                        AWorkbench.popup((String)"No Goals to Display");
                    } else {
                        WorldXWidgetActionPage.this.worldComposite.load(WorldXWidgetActionPage.this.worldEditor.getWorldXWidgetActionPage().getCurrentTitleLabel(), goals, new XNavigateComposite.TableLoadOption[0]);
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void redisplayAsWorkFlow() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Re-display as WorkFlows"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<Artifact> arts = new HashSet<Artifact>();
                    for (Artifact art : artifacts) {
                        Artifact parentArt;
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getWorkItemService().getTeams((Object)art))));
                            continue;
                        }
                        if (!(art instanceof AbstractWorkflowArtifact) || (parentArt = (Artifact)((AbstractWorkflowArtifact)art).getParentTeamWorkflow()) == null) continue;
                        arts.add(parentArt);
                    }
                    if (arts.isEmpty()) {
                        AWorkbench.popup((String)"No Workflows to Display");
                    } else {
                        WorldXWidgetActionPage.this.worldComposite.load(WorldXWidgetActionPage.this.worldEditor.getWorldXWidgetActionPage().getCurrentTitleLabel(), arts, new XNavigateComposite.TableLoadOption[0]);
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void redisplayAsTask() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Re-display as Tasks"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet arts = new HashSet();
                    for (Artifact art : artifacts) {
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)art)) {
                                arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getTaskService().getTasks(team))));
                            }
                            continue;
                        }
                        if (!(art instanceof TeamWorkFlowArtifact)) continue;
                        arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)art)))));
                    }
                    if (arts.isEmpty()) {
                        AWorkbench.popup((String)"No Tasks to Display");
                    } else {
                        WorldXWidgetActionPage.this.worldComposite.load(WorldXWidgetActionPage.this.worldEditor.getWorldXWidgetActionPage().getCurrentTitleLabel(), arts, new XNavigateComposite.TableLoadOption[0]);
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void redisplayAsReviews() {
        final List<Artifact> artifacts = this.worldComposite.getXViewer().getLoadedArtifacts();
        Job job = new Job("Re-display as Reviews"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    HashSet<AbstractReviewArtifact> arts = new HashSet<AbstractReviewArtifact>();
                    for (Artifact art : artifacts) {
                        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)art)) {
                                arts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getReviewService().getReviews(team))));
                            }
                            continue;
                        }
                        if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
                        arts.addAll(ReviewManager.getReviews((TeamWorkFlowArtifact)art));
                    }
                    if (arts.isEmpty()) {
                        AWorkbench.popup((String)"No Reviews to Display");
                    } else {
                        WorldXWidgetActionPage.this.worldComposite.load(WorldXWidgetActionPage.this.worldEditor.getWorldXWidgetActionPage().getCurrentTitleLabel(), arts, new XNavigateComposite.TableLoadOption[0]);
                    }
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)true);
    }

    public void updateExtendedStatusString() {
        this.worldComposite.getXViewer().setExtendedStatusString(String.valueOf(filterCompletedAction.isChecked() ? "[Complete/Cancel Filter]" : "") + (filterMyAssigneeAction.isChecked() ? "[My Assignee Filter]" : ""));
    }

    public void createParametersSectionCompleted(IManagedForm managedForm, Composite mainComp) {
        try {
            if (this.worldEditor.getWorldEditorProvider() instanceof IWorldEditorParameterProvider) {
                IWorldEditorParameterProvider provider = (IWorldEditorParameterProvider)this.worldEditor.getWorldEditorProvider();
                provider.createParametersSectionCompleted(managedForm, mainComp);
                String editorTitle = provider.getSelectedName(WorldSearchItem.SearchType.Search);
                if (Strings.isValid((String)editorTitle)) {
                    ((WorldEditor)this.getEditor()).setEditorTitle(editorTitle);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public class DropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public DropDownAction() {
            this.setText("Other");
            this.setMenuCreator(this);
            this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GEAR));
            this.addKeyListener();
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            this.addActionToMenu(this.fMenu, WorldXWidgetActionPage.this.workflowMetricsUi.getOrCreateAction());
            this.addActionToMenu(this.fMenu, filterCompletedAction);
            this.addActionToMenu(this.fMenu, filterMyAssigneeAction);
            if (!WorldXWidgetActionPage.this.worldEditor.isTaskEditor()) {
                new MenuItem(this.fMenu, 2);
                this.addActionToMenu(this.fMenu, toAction);
                this.addActionToMenu(this.fMenu, toGoal);
                this.addActionToMenu(this.fMenu, toWorkFlow);
                this.addActionToMenu(this.fMenu, toTask);
                this.addActionToMenu(this.fMenu, toReview);
            }
            WorldXWidgetActionPage.this.worldEditor.createToolBarPulldown(this.fMenu);
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public void run() {
        }

        void clear() {
            this.dispose();
        }

        private void addKeyListener() {
            Tree tree = WorldXWidgetActionPage.this.worldComposite.getXViewer().getTree();
            GridData gridData = new GridData(1808);
            gridData.heightHint = 100;
            gridData.widthHint = 100;
            tree.setLayoutData((Object)gridData);
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            WorldXWidgetActionPage.this.worldComposite.getXViewer().getTree().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                }

                public void keyReleased(KeyEvent event) {
                    if ((event.stateMask & SWT.MODIFIER_MASK) == 262144) {
                        if (event.keyCode == 97) {
                            ((DropDownAction)DropDownAction.this).WorldXWidgetActionPage.this.worldComposite.getXViewer().getTree().setSelection(((DropDownAction)DropDownAction.this).WorldXWidgetActionPage.this.worldComposite.getXViewer().getTree().getItems());
                        } else if (event.keyCode == 120) {
                            ((DropDownAction)DropDownAction.this).WorldXWidgetActionPage.this.workflowMetricsUi.getOrCreateAction().setChecked(!((DropDownAction)DropDownAction.this).WorldXWidgetActionPage.this.workflowMetricsUi.getOrCreateAction().isChecked());
                            ((DropDownAction)DropDownAction.this).WorldXWidgetActionPage.this.workflowMetricsUi.getOrCreateAction().run();
                        } else if (event.keyCode == 102) {
                            filterCompletedAction.setChecked(!filterCompletedAction.isChecked());
                            filterCompletedAction.run();
                        } else if (event.keyCode == 103) {
                            filterMyAssigneeAction.setChecked(!filterMyAssigneeAction.isChecked());
                            filterMyAssigneeAction.run();
                        } else if (event.keyCode == 100) {
                            filterMyAssigneeAction.setChecked(!filterMyAssigneeAction.isChecked());
                            filterCompletedAction.setChecked(!filterCompletedAction.isChecked());
                            filterCompletedAction.run();
                            filterMyAssigneeAction.run();
                        }
                    }
                }
            });
        }
    }
}

