/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.duplicate;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.clone.CloneData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XAgileFeatureHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XAssigneesHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XOriginatorHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XSprintHyperlinkWidget;
import org.eclipse.osee.ats.ide.util.widgets.XTargetedVersionHyperlinkWidget;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XFloat;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.XWidgetsDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CloneDialog
extends XWidgetsDialog {
    private final IAtsTeamWorkflow teamWf;
    private final AtsApi atsApi;
    private final CloneData data;

    public CloneDialog(String dialogTitle, String dialogMessage, IAtsTeamWorkflow teamWf, CloneData data) {
        super(dialogTitle, dialogMessage);
        this.teamWf = teamWf;
        this.data = data;
        this.atsApi = AtsApiService.get();
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<XWidgets>");
        builder.append("<XWidget xwidgetType=\"XText\" displayName=\"Title\" id=\"title\"/>");
        builder.append("<XWidget xwidgetType=\"XText\" displayName=\"Description\" height=\"60\" id=\"desc\" fill=\"Vertically\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Create New Action with Workflow\" toolTip=\"Un-Check to add Workflow to this Action, otherwise new Workflow will belong to this Action.\"  id=\"newAction\" defaultValue=\"true\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"   \" />");
        builder.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Set or clear items for new workflow:\" />");
        builder.append("<XWidget xwidgetType=\"XOriginatorHyperlinkWidget\" displayName=\"Originator\" id=\"orig\" />");
        builder.append("<XWidget xwidgetType=\"XAssigneesHyperlinkWidget\" displayName=\"Assignees\" id=\"assign\" />");
        builder.append("<XWidget beginComposite=\"6\" xwidgetType=\"XCombo(" + this.getChangeTypeOptions() + ")\" horizontalLabel=\"true\" displayName=\"Change Type\" />");
        builder.append("<XWidget xwidgetType=\"XCombo(" + this.getPriorityOptions() + ")\" horizontalLabel=\"true\" displayName=\"Priority\" />");
        builder.append("<XWidget endComposite=\"true\" xwidgetType=\"XFloat\" displayName=\"Agile Points\" />");
        builder.append("<XWidget xwidgetType=\"XTargetedVersionHyperlinkWidget\" displayName=\"Targeted Version\" />");
        IAgileTeam agileTeam = this.atsApi.getAgileService().getAgileTeam((IAtsWorkItem)this.teamWf);
        if (agileTeam != null) {
            builder.append("<XWidget xwidgetType=\"XAgileFeatureHyperlinkWidget\" displayName=\"Agile Feature(s)\" />");
            builder.append("<XWidget xwidgetType=\"XSprintHyperlinkWidget\" displayName=\"Agile Sprint\" />");
        }
        builder.append("</XWidgets>");
        return builder.toString();
    }

    private String getPriorityOptions() {
        return Collections.toString((String)",", (Iterable)AtsAttributeTypes.Priority.getEnumStrValues());
    }

    private String getChangeTypeOptions() {
        return Collections.toString((String)",", (Iterable)AtsAttributeTypes.ChangeType.getEnumStrValues());
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals("Title")) {
            final XText widget = (XText)xWidget;
            String title = "(Cloned) " + this.teamWf.getName();
            widget.set(title);
            widget.refresh();
            this.data.setTitle(title);
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget22) {
                    CloneDialog.this.data.setTitle(widget.get());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget.getLabel().equals("Description")) {
            final XText widget = (XText)xWidget;
            widget.setText(this.teamWf.getDescription());
            widget.refresh();
            this.data.setDesc(this.teamWf.getDescription());
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget22) {
                    CloneDialog.this.data.setDesc(widget.get());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget.getLabel().equals("Assignees")) {
            final XAssigneesHyperlinkWidget widget = (XAssigneesHyperlinkWidget)xWidget;
            widget.getSelected().addAll(this.teamWf.getAssignees());
            widget.refresh();
            this.data.setAssignees((Collection)this.teamWf.getAssignees());
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget22) {
                    CloneDialog.this.data.setAssignees(widget.getAssignees());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget.getLabel().equals("Originator")) {
            final XOriginatorHyperlinkWidget widget = (XOriginatorHyperlinkWidget)xWidget;
            widget.setSelected(this.teamWf.getCreatedBy());
            widget.refresh();
            this.data.setOriginator(this.teamWf.getCreatedBy());
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget2) {
                    CloneDialog.this.data.setOriginator(widget.getSelected());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget.getLabel().equals("Change Type")) {
            final XCombo widget = (XCombo)xWidget;
            String changeType = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.teamWf, (AttributeTypeToken)AtsAttributeTypes.ChangeType, (Object)"");
            widget.set(changeType);
            widget.refresh();
            this.data.setChangeType(changeType);
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget2) {
                    CloneDialog.this.data.setChangeType(widget.get());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget.getLabel().equals("Priority")) {
            final XCombo widget = (XCombo)xWidget;
            String priority = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.teamWf, (AttributeTypeToken)AtsAttributeTypes.Priority, (Object)"");
            widget.set(priority);
            widget.refresh();
            this.data.setPriority(priority);
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget2) {
                    CloneDialog.this.data.setPriority(widget.get());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget.getLabel().equals("Agile Points")) {
            final XFloat widget = (XFloat)xWidget;
            String pointsStr = this.atsApi.getAgileService().getAgileTeamPointsStr((IAtsWorkItem)this.teamWf);
            widget.set(pointsStr);
            widget.refresh();
            this.data.setPoints(pointsStr);
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget2) {
                    CloneDialog.this.data.setPoints(widget.get());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget.getLabel().equals("Targeted Version")) {
            final XTargetedVersionHyperlinkWidget widget = (XTargetedVersionHyperlinkWidget)xWidget;
            widget.getSelectable().addAll(this.atsApi.getVersionService().getVersions(this.atsApi.getTeamDefinitionService().getTeamDefHoldingVersions(this.teamWf.getTeamDefinition()), VersionReleaseType.UnReleased, VersionLockedType.UnLocked));
            IAtsVersion version = this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)this.teamWf);
            widget.setVersion(version);
            widget.refresh();
            this.data.setTargetedVersion(version);
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget2) {
                    CloneDialog.this.data.setTargetedVersion(widget.getSelected());
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget instanceof XAgileFeatureHyperlinkWidget) {
            final XAgileFeatureHyperlinkWidget widget = (XAgileFeatureHyperlinkWidget)xWidget;
            widget.setTeamWf(this.teamWf);
            for (IAgileFeatureGroup feature : this.atsApi.getAgileService().getFeatureGroups((IAtsWorkItem)this.teamWf)) {
                widget.getFeatures().add(feature);
                this.data.getFeatures().add(feature.getName());
            }
            widget.refresh();
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget2) {
                    CloneDialog.this.data.getFeatures().clear();
                    for (IAgileFeatureGroup feature : widget.getFeatures()) {
                        CloneDialog.this.data.getFeatures().add(feature.getName());
                    }
                    CloneDialog.this.handleModified();
                }
            });
        } else if (xWidget instanceof XSprintHyperlinkWidget) {
            final XSprintHyperlinkWidget widget = (XSprintHyperlinkWidget)xWidget;
            widget.setTeamWf(this.teamWf);
            IAgileSprint sprint = this.atsApi.getAgileService().getSprint(this.teamWf);
            widget.setSprint(sprint);
            widget.refresh();
            this.data.setSprint(sprint);
            widget.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget2) {
                    CloneDialog.this.data.setSprint(widget.getSelected());
                    CloneDialog.this.handleModified();
                }
            });
        }
    }

    public boolean isEntryValid() {
        if (Strings.isInValid((String)this.data.getTitle())) {
            this.logError("Title must be entered");
            return false;
        }
        if (Strings.isInValid((String)this.data.getDesc())) {
            this.logError("Description must be entered");
            return false;
        }
        if (Strings.isInValid((String)this.data.getPriority())) {
            this.logError("Priority must be selected");
            return false;
        }
        if (Strings.isInValid((String)this.data.getChangeType())) {
            this.logError("Change Type must be selected");
            return false;
        }
        if (this.data.getOriginator() == null) {
            this.logError("Originator must be selected");
            return false;
        }
        this.logError("");
        return true;
    }
}

