/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.walker.IActionWalkerItem;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class SprintMemberWrapper
implements IActionWalkerItem {
    private final IAgileSprint sprint;

    public SprintMemberWrapper(IAgileSprint sprint) {
        this.sprint = sprint;
    }

    public String toString() {
        try {
            return String.format(String.valueOf(AtsApiService.get().getAgileService().getItems(this.sprint).size()) + " Members", new Object[0]);
        }
        catch (OseeCoreException ex) {
            return "Exception: " + ex.getLocalizedMessage();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.sprint == null ? 0 : this.sprint.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SprintMemberWrapper other = (SprintMemberWrapper)obj;
        return !(this.sprint == null ? other.sprint != null : !this.sprint.equals(other.sprint));
    }

    @Override
    public Image getImage() {
        return ImageManager.getImage((KeyedImage)AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_SPRINT));
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public void handleDoubleClick() {
        try {
            AtsEditors.openInAtsWorldEditor(String.format("Goal [%s] Members", this.sprint.getName()), AtsObjects.getArtifacts((Collection)AtsApiService.get().getAgileService().getItems(this.sprint)));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

