/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.xviewer.column;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.AtsAttrValCol;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.PromptChangeUtil;
import org.eclipse.osee.ats.ide.util.xviewer.column.AtsAttributeColumnUtility;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.DisplayHint;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerAtsAttributeValueColumn
extends XViewerAtsAttributeColumn
implements IAltLeftClickProvider,
IMultiColumnEditProvider,
IXViewerValueColumn {
    String booleanOnTrueShow = null;
    String booleanOnFalseShow = null;
    String booleanNotSetShow = null;

    public XViewerAtsAttributeValueColumn(AttributeTypeToken attributeType, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(attributeType, attributeType.getName(), attributeType.getUnqualifiedName(), width, align, show, sortDataType, multiColumnEditable, description);
    }

    public XViewerAtsAttributeValueColumn(AttributeTypeToken attributeType, String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(attributeType, id, name, width, align, show, sortDataType, multiColumnEditable, description);
    }

    public XViewerAtsAttributeValueColumn(AtsAttrValCol column) {
        super((AttributeTypeToken)AttributeTypeManager.getAttributeType((Long)column.getAttrTypeId()), column.getId(), column.getName(), column.getWidth(), AtsEditors.getXViewerAlign(column.getAlign()), column.isVisible(), XViewerAtsAttributeValueColumn.getSortDataType(column), column.isColumnMultiEdit(), column.getDescription());
        this.setInheritParent(column.isInheritParent());
        this.setActionRollup(column.isActionRollup());
    }

    private static SortDataType getSortDataType(AtsAttrValCol column) {
        SortDataType result = SortDataType.String;
        try {
            result = SortDataType.valueOf((String)column.getSortDataType());
        }
        catch (Exception exception) {}
        return result;
    }

    protected XViewerAtsAttributeValueColumn() {
    }

    protected Artifact getParentTeamWorkflowOrArtifact(Object element) {
        Artifact useArt = null;
        if (element instanceof Artifact) {
            useArt = element instanceof AbstractWorkflowArtifact ? (Artifact)((AbstractWorkflowArtifact)((Object)element)).getParentTeamWorkflow() : AtsApiService.get().getQueryServiceIde().getArtifact(element);
        }
        return useArt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof Artifact && AtsApiService.get().getQueryServiceIde().getArtifact(element).isDeleted()) {
                return "<deleted>";
            }
            if (this.isBooleanShow() && column.getSortDataType() == SortDataType.Boolean && element instanceof AbstractWorkflowArtifact) {
                if (this.attributeType.getDisplayHints().contains(DisplayHint.YesNoBoolean) && AtsApiService.get().getAttributeResolver().isAttributeTypeValid((IAtsWorkItem)element, this.attributeType)) {
                    Boolean set = (Boolean)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((ArtifactId)((Artifact)element), this.attributeType, null);
                    if (set == null) {
                        return "";
                    }
                    if (set == false) return "No";
                    return "Yes";
                }
                Boolean value = (Boolean)((AbstractWorkflowArtifact)((Object)element)).getSoleAttributeValue((AttributeTypeId)this.getAttributeType(), null);
                if (value == null && this.booleanNotSetShow != null) {
                    return this.booleanNotSetShow;
                }
                if (value != null) {
                    if (value.booleanValue() && this.booleanOnTrueShow != null) {
                        return this.booleanOnTrueShow;
                    }
                    if (!value.booleanValue() && this.booleanOnFalseShow != null) {
                        return this.booleanOnFalseShow;
                    }
                }
            }
            if (element instanceof AbstractWorkflowArtifact) {
                AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)((Object)element);
                String result = awa.getAttributesToStringUnique((AttributeTypeId)this.getAttributeType(), ";");
                if (Strings.isValid((String)result)) {
                    return result;
                }
                if (this.isInheritParentWithDefault() && !awa.isTeamWorkflow() && awa.getParentTeamWorkflow() != null && Strings.isValid((String)(result = Collections.toString((String)"; ", (Iterable)((Artifact)awa.getParentTeamWorkflow()).getAttributesToStringList((AttributeTypeId)this.getAttributeType()))))) {
                    return result;
                }
            }
            if (!Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) return "";
            if (!this.isActionRollupWithDefault()) return "";
            LinkedHashSet<String> strs = new LinkedHashSet<String>();
            Iterator iterator = AtsApiService.get().getWorkItemService().getTeams(element).iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return Collections.toString((String)"; ", strs);
                }
                IAtsTeamWorkflow team = (IAtsTeamWorkflow)iterator.next();
                String str = this.getColumnText(team, column, columnIndex);
                if (!Strings.isValid((String)str)) continue;
                strs.add(str);
            }
        }
        catch (Exception ex) {
            return LogUtil.getCellExceptionString((Exception)ex);
        }
    }

    private boolean isActionRollupWithDefault() {
        if (this.isActionRollup() == null) {
            return false;
        }
        return this.isActionRollup();
    }

    private boolean isInheritParentWithDefault() {
        if (this.isInheritParent() == null) {
            return false;
        }
        return this.isInheritParent();
    }

    private boolean isBooleanShow() {
        return this.booleanOnFalseShow != null || this.booleanOnTrueShow != null || this.booleanNotSetShow != null || this.attributeType.getDisplayHints().contains(DisplayHint.YesNoBoolean);
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeColumn != null && !treeColumn.isDisposed() && treeItem != null && !treeItem.isDisposed() && this.isMultiColumnEditable()) {
            return AtsAttributeColumnUtility.handleAltLeftClick(treeColumn.getData(), treeItem.getData(), this.isPersistAltLeftClick());
        }
        return false;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        LinkedHashSet<AbstractWorkflowArtifact> awas = new LinkedHashSet<AbstractWorkflowArtifact>();
        for (TreeItem item : treeItems) {
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            try {
                if (!(art instanceof AbstractWorkflowArtifact) || !art.isAttributeTypeValid((AttributeTypeId)this.getAttributeType())) continue;
                awas.add((AbstractWorkflowArtifact)art);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        if (awas.isEmpty()) {
            AWorkbench.popup((String)"Invalid Selection", (String)String.format("No selected items valid for attribute [%s] editing", this.getAttributeType()));
            return;
        }
        PromptChangeUtil.promptChangeAttribute(awas, this.getAttributeType(), AtsAttributeColumnUtility.isPersistViewer((XViewer)this.getXViewer()));
        ((XViewer)this.getXViewer()).update(awas.toArray(), null);
    }

    @Override
    public XViewerAtsAttributeValueColumn copy() {
        XViewerAtsAttributeValueColumn newXCol = new XViewerAtsAttributeValueColumn();
        this.copy(this, newXCol);
        newXCol.setBooleanNotSetShow(this.getBooleanNotSetShow());
        newXCol.setBooleanOnFalseShow(this.getBooleanOnFalseShow());
        newXCol.setBooleanOnTrueShow(this.getBooleanOnTrueShow());
        newXCol.setInheritParent(this.isInheritParent());
        newXCol.setActionRollup(this.isActionRollup());
        return newXCol;
    }

    public String getBooleanOnTrueShow() {
        return this.booleanOnTrueShow;
    }

    public void setBooleanOnTrueShow(String booleanOnTrueShow) {
        this.booleanOnTrueShow = booleanOnTrueShow;
    }

    public String getBooleanOnFalseShow() {
        return this.booleanOnFalseShow;
    }

    public void setBooleanOnFalseShow(String booleanOnFalseShow) {
        this.booleanOnFalseShow = booleanOnFalseShow;
    }

    public String getBooleanNotSetShow() {
        return this.booleanNotSetShow;
    }

    public void setBooleanNotSetShow(String booleanNotSetShow) {
        this.booleanNotSetShow = booleanNotSetShow;
    }
}

