/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.details;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.access.IAtsAccessService;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeDetailsTab
extends WfeAbstractTab {
    private ScrolledForm scrolledForm;
    public static final String ID = "ats.details.tab";
    private final WorkflowEditor editor;
    private Browser browser;

    public WfeDetailsTab(WorkflowEditor editor, IAtsWorkItem workItem) {
        super(editor, ID, workItem, "Details");
        this.editor = editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.scrolledForm = managedForm.getForm();
        try {
            this.bodyComp = this.scrolledForm.getBody();
            GridLayout gridLayout = new GridLayout(1, true);
            this.bodyComp.setLayout((Layout)gridLayout);
            GridData gd = new GridData(16384, 16384, true, true);
            this.bodyComp.setLayoutData((Object)gd);
            this.browser = new Browser(this.bodyComp, 0);
            this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
            this.updateTitleBar(managedForm);
            this.createToolbar(managedForm);
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
            this.refresh();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void refresh() {
        WfeDetailsTab.refreshBrowser(this.browser, this.editor, this.getManagedForm());
    }

    public static void refreshBrowser(Browser browser, WorkflowEditor editor, IManagedForm managedForm) {
        if (Widgets.isAccessible((Widget)browser)) {
            AbstractWorkflowArtifact workItem = editor.getWorkItem();
            try {
                Map smaDetails = Artifacts.getDetailsKeyValues((Artifact)((Artifact)workItem.getStoreObject()));
                WfeDetailsTab.addSMADetails(workItem, smaDetails);
                FontData systemFont = browser.getDisplay().getSystemFont().getFontData()[0];
                String formattedDetails = Artifacts.getDetailsFormText((Map)smaDetails, (String)systemFont.getName(), (int)systemFont.getHeight());
                browser.setText(formattedDetails);
            }
            catch (Exception ex) {
                browser.setText(Lib.exceptionToString((Exception)ex));
            }
            managedForm.reflow(true);
        }
    }

    private static void addSMADetails(IAtsWorkItem workItem, Map<String, String> details) {
        details.put("Workflow Definition", workItem.getWorkDefinition().getName());
        IAtsAction parentAction = workItem.getParentAction();
        if (parentAction == null) {
            details.put("Action Id", "No Parent Action");
        } else {
            details.put("Action Id", parentAction.getAtsId());
        }
        if (!workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow}) && workItem.getParentTeamWorkflow() != null) {
            details.put("Parent Team Workflow Id", workItem.getParentTeamWorkflow().getAtsId());
        }
        if (workItem.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            details.put("Working Branch Access Context Id", WfeDetailsTab.getAccessContextId((TeamWorkFlowArtifact)workItem));
        }
    }

    private static String getAccessContextId(TeamWorkFlowArtifact workflow) {
        String message;
        IAtsAccessService accessService = AtsApiService.get().getAtsAccessService();
        BranchToken workingBranch = null;
        try {
            workingBranch = workflow.getWorkingBranch();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        Collection ids = null;
        if (workingBranch == null) {
            try {
                ids = accessService.getFromWorkflow((IAtsTeamWorkflow)workflow);
                message = ids.toString();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                message = String.format("Error getting context id [%s]", ex.getMessage());
            }
        } else {
            try {
                ids = accessService.getContextIds((BranchId)workingBranch);
                message = ids.toString();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                message = String.format("Error getting context id [%s]", ex.getMessage());
            }
        }
        return message;
    }
}

