/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit.action;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.util.AtsTopicEvent;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactState;
import org.eclipse.osee.ats.ide.editor.tab.bit.WfeBitTab;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ProgramVersion;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ProgramVersionTreeDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class NewProgramVersionAction
extends Action {
    private final IAtsTeamWorkflow teamWf;
    private final AtsApi atsApi;
    private final WfeBitTab wfeBitTab;

    public NewProgramVersionAction(IAtsTeamWorkflow teamWf, WfeBitTab wfeBitTab) {
        this.teamWf = teamWf;
        this.wfeBitTab = wfeBitTab;
        this.atsApi = AtsApiService.get();
    }

    public void run() {
        ArrayList<ProgramVersion> pvers = new ArrayList<ProgramVersion>();
        for (ArtifactToken progArt : ArtifactQuery.getArtifactListFromTypeWithInheritence((ArtifactTypeToken)AtsArtifactTypes.Program, (BranchId)CoreBranches.COMMON, (DeletionFlag)DeletionFlag.EXCLUDE_DELETED)) {
            IAtsProgram program = this.atsApi.getProgramService().getProgramById((ArtifactId)progArt);
            for (ArtifactToken verArt : this.atsApi.getProgramService().getVersionsForProgram((ArtifactId)program.getArtifactToken(), false).getVersions()) {
                Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)verArt);
                pvers.add(new ProgramVersion(program, (IAtsVersion)version));
            }
        }
        ProgramVersionTreeDialog dialog = new ProgramVersionTreeDialog(pvers);
        if (dialog.open() == 0) {
            BuildImpactDatas bids = new BuildImpactDatas();
            bids.setTeamWf(this.teamWf.getStoreObject());
            bids.setBidArtType(this.wfeBitTab.getBuildImpactDataType());
            for (ProgramVersion pVer : dialog.getChecked()) {
                BuildImpactData bid = new BuildImpactData();
                bid.setBids(bids);
                bid.setBidArt(ArtifactToken.valueOf((ArtifactId)ArtifactId.SENTINEL, (String)pVer.getVersion().getName()));
                bid.setBuild(pVer.getVersion().getArtifactToken());
                bid.setProgram(pVer.getProgram().getArtifactToken());
                bid.setState(BuildImpactState.Open.getName());
                bids.addBuildImpactData(bid);
            }
            bids = this.atsApi.getServerEndpoints().getActionEndpoint().updateBids(this.teamWf.getAtsId(), bids);
            if (bids.getResults().isErrors()) {
                XResultDataUI.report((XResultData)bids.getResults(), (String)"Error creating BIDs");
            } else {
                ((Artifact)this.teamWf).reloadAttributesAndRelations();
                this.atsApi.getEventService().postAtsWorkItemTopicEvent(AtsTopicEvent.WORK_ITEM_MODIFIED, Arrays.asList(this.teamWf), bids.getTransaction());
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GREEN_PLUS);
    }

    public String getText() {
        return "Add Impacted Program / Build";
    }

    public boolean isEnabled() {
        return this.teamWf.isInWork();
    }
}

