/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.bit;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.config.JaxTeamWorkflow;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitViewer;
import org.eclipse.osee.ats.ide.editor.tab.bit.XBitXViewerFactory;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class XBitLabelProvider
extends XViewerLabelProvider {
    private final XBitViewer xBitViewer;

    public XBitLabelProvider(XBitViewer xBitViewer) {
        super((XViewer)xBitViewer);
        this.xBitViewer = xBitViewer;
    }

    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        if (element instanceof TaskEstDefinition) {
            return null;
        }
        return super.getForeground(element, xCol, columnIndex);
    }

    public Color getBackground(Object element, XViewerColumn xCol, int columnIndex) {
        if (element instanceof TaskEstDefinition) {
            return null;
        }
        return super.getBackground(element, xCol, columnIndex);
    }

    public String getColumnText(Object element, int columnIndex) {
        XViewerColumn xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
        if (element instanceof BuildImpactData) {
            BuildImpactData bid = (BuildImpactData)element;
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Program_Col.getName())) {
                return bid.getProgram().getName();
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Build_Col.getName())) {
                return bid.getBuild().getName();
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Config_Col.getName())) {
                Artifact bidArt = (Artifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)bid.getBidArt());
                ArrayList<String> configs = new ArrayList<String>();
                for (String configIdStr : AtsApiService.get().getAttributeResolver().getAttributesToStringList((ArtifactId)bidArt, (AttributeTypeToken)AtsAttributeTypes.BitConfig)) {
                    Long configId = Long.valueOf(configIdStr);
                    ArtifactToken config = (ArtifactToken)this.xBitViewer.getBids().getIdToConfig().get(configId);
                    configs.add(config.getName());
                }
                return Collections.toString((String)",", configs);
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.State_Col.getName())) {
                return bid.getState();
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Id_Col.getName())) {
                return bid.getBidArt().getIdString();
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Cr_State_Col.getName())) {
                if (bid.getTeamWfs().isEmpty()) {
                    return "None Created";
                }
                int completed = 0;
                for (JaxTeamWorkflow teamWf : bid.getTeamWfs()) {
                    if (!teamWf.getStateType().isCompletedOrCancelled()) continue;
                    ++completed;
                }
                return String.format("%s of %s Completed", completed, bid.getTeamWfs().size());
            }
        }
        if (element instanceof JaxTeamWorkflow) {
            JaxTeamWorkflow teamWf = (JaxTeamWorkflow)element;
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Id_Col.getName())) {
                return teamWf.getAtsId();
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Cr_State_Col.getName())) {
                return teamWf.getCurrentState();
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Cr_Title_Col.getName())) {
                return teamWf.getName();
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Cr_Type_Col.getName())) {
                return teamWf.getTeamName();
            }
        }
        return "";
    }

    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        XViewerColumn xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
        if (element instanceof JaxTeamWorkflow && xViewerColumn.getName().equals(XBitXViewerFactory.Cr_Type_Col.getName())) {
            return ImageManager.getImage((OseeImage)AtsImage.WORKFLOW);
        }
        if (element instanceof BuildImpactData) {
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Program_Col.getName())) {
                return ImageManager.getImage((OseeImage)AtsImage.PROGRAM);
            }
            if (xViewerColumn.getName().equals(XBitXViewerFactory.Build_Col.getName())) {
                return ImageManager.getImage((OseeImage)AtsImage.VERSION);
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getColumnText(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        return "";
    }
}

