/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.attributes;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.BranchIdEventFilter;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.skynet.action.RefreshAction;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.tab.attr.ArtEdAttrTab;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.tab.attr.ArtEdAttrToolbar;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.tab.attr.ArtEdAttrXViewer;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeAttributesTab
extends WfeAbstractTab
implements RefreshAction.IRefreshActionHandler,
IArtifactEventListener {
    private ScrolledForm scrolledForm;
    public static final String ID = "ats.attributes.tab";
    private final WorkflowEditor editor;
    private ArtEdAttrTab artEdAttrTab;
    private Artifact artifact;
    private ArtEdAttrXViewer xViewer;

    public WfeAttributesTab(WorkflowEditor editor, IAtsWorkItem workItem) {
        super(editor, ID, editor.getWorkItem(), "Attributes");
        this.editor = editor;
        this.artifact = (Artifact)workItem;
        OseeEventManager.addListener((IEventListener)this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.scrolledForm = managedForm.getForm();
        this.bodyComp = this.scrolledForm.getBody();
        this.artEdAttrTab = new ArtEdAttrTab((FormEditor)this.editor, (Artifact)this.editor.getWorkItem());
        this.artEdAttrTab.createFormContentShared(managedForm);
        this.getSite().setSelectionProvider((ISelectionProvider)this.xViewer);
        this.artifact = this.artEdAttrTab.getArtifact();
        this.xViewer = this.artEdAttrTab.getxViewer();
        this.updateTitleBar(managedForm);
        this.createToolbar(managedForm);
        FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
    }

    public void refreshActionHandler() {
        this.artifact = this.artifact.reloadAttributesAndRelations();
        this.refresh();
    }

    public void refresh() {
        if (this.xViewer != null) {
            this.xViewer.loadTable(this.artifact);
        }
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        if (this.xViewer != null && artifactEvent.isModified(this.artifact)) {
            this.xViewer.loadTable(this.artifact);
        }
    }

    public List<? extends IEventFilter> getEventFilters() {
        return Arrays.asList(new BranchIdEventFilter((BranchId)this.artifact.getBranch()));
    }

    @Override
    public IToolBarManager createToolbar(IManagedForm managedForm) {
        IToolBarManager toolBarMgr = this.scrolledForm.getToolBarManager();
        toolBarMgr.removeAll();
        ArtEdAttrToolbar artEdAttrToolbar = new ArtEdAttrToolbar(this.scrolledForm, this.xViewer, new RefreshAction.IRefreshActionHandler(){

            public void refreshActionHandler() {
                WfeAttributesTab.this.artEdAttrTab.refreshActionHandler();
            }
        });
        artEdAttrToolbar.addAttrToolbarActions(toolBarMgr);
        super.createToolbar(managedForm);
        return toolBarMgr;
    }
}

