/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import com.google.common.base.Supplier;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.MatchLocation;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.LoadDataHandlerDecorator;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphBuilder;
import org.eclipse.osee.orcs.core.internal.proxy.ExternalArtifactManager;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.search.Match;

public class ArtifactMatchDataHandler
extends LoadDataHandlerDecorator {
    private final ExternalArtifactManager proxyManager;
    private Map<ArtifactId, ArtifactMatch> matches;
    private List<Match<ArtifactReadable, AttributeReadable<?>>> results;

    public ArtifactMatchDataHandler(GraphBuilder handler, ExternalArtifactManager proxyManager) {
        super(handler);
        this.proxyManager = proxyManager;
    }

    @Override
    protected GraphBuilder getHandler() {
        return (GraphBuilder)super.getHandler();
    }

    @Override
    public void onLoadStart() {
        super.onLoadStart();
        this.matches = new HashMap<ArtifactId, ArtifactMatch>();
        this.results = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void onData(AttributeData<T> data, MatchLocation match) {
        super.onData(data, match);
        ArtifactId artId = data.getArtifactId();
        Map<ArtifactId, ArtifactMatch> map = this.matches;
        synchronized (map) {
            ArtifactMatch artifactMatch = this.matches.get(artId);
            if (artifactMatch == null) {
                artifactMatch = new ArtifactMatch();
                this.matches.put(artId, artifactMatch);
            }
            artifactMatch.addLocation(data, match);
        }
    }

    @Override
    public void onLoadEnd() {
        super.onLoadEnd();
        this.buildResults();
    }

    private void buildResults() {
        Iterable<Artifact> loaded = this.getHandler().getArtifacts();
        for (Artifact item : loaded) {
            ArtifactMatch artifactMatch = this.matches.get(item);
            if (artifactMatch != null) {
                ArtifactReadable readable = this.proxyManager.asExternalArtifact(null, item);
                artifactMatch.setArtifactReadable(readable);
            }
            if (this.results == null) {
                this.results = Lists.newLinkedList();
            }
            this.results.add(artifactMatch);
        }
        this.matches = null;
    }

    public List<Match<ArtifactReadable, AttributeReadable<?>>> getResults() {
        return this.results != null ? this.results : Collections.emptyList();
    }

    private static <K, V> ListMultimap<K, V> newLinkedHashListMultimap() {
        LinkedHashMap map = new LinkedHashMap();
        return Multimaps.newListMultimap(map, (Supplier)new Supplier<List<V>>(){

            public List<V> get() {
                return Lists.newArrayList();
            }
        });
    }

    static /* synthetic */ ListMultimap access$1() {
        return ArtifactMatchDataHandler.newLinkedHashListMultimap();
    }

    private static final class ArtifactMatch
    implements Match<ArtifactReadable, AttributeReadable<?>> {
        private final ListMultimap<AttributeId, MatchLocation> attributeMatches = ArtifactMatchDataHandler.access$1();
        private ArtifactReadable item;

        public void setArtifactReadable(ArtifactReadable item) {
            this.item = item;
        }

        public void addLocation(AttributeId attrId, MatchLocation location) {
            this.attributeMatches.put((Object)attrId, (Object)location);
        }

        public boolean hasLocationData() {
            return !this.attributeMatches.isEmpty();
        }

        public ArtifactReadable getItem() {
            return this.item;
        }

        public Collection<AttributeReadable<?>> getElements() {
            LinkedList filtered = Lists.newLinkedList();
            for (AttributeReadable attribute : this.item.getAttributes(DeletionFlag.INCLUDE_DELETED)) {
                if (!this.attributeMatches.containsKey((Object)attribute)) continue;
                filtered.add(attribute);
            }
            return filtered;
        }

        public List<MatchLocation> getLocation(AttributeReadable<?> element) {
            List<MatchLocation> toReturn = this.attributeMatches.get(element);
            return toReturn != null ? toReturn : Collections.emptyList();
        }

        public String toString() {
            return "ArtifactMatch [item=" + this.item + ", matches=" + this.attributeMatches + "]";
        }
    }
}

