/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.resources;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.disposition.model.DispoProgamDescriptorData;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.resources.DispoAdminResource;
import org.eclipse.osee.disposition.rest.resources.DispoConfigResource;
import org.eclipse.osee.disposition.rest.resources.DispoSetResource;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.JsonUtil;

@Path(value="program")
public class DispoProgramResource {
    private final DispoApi dispoApi;

    public DispoProgramResource(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createProgram(DispoProgamDescriptorData programDescriptor, @QueryParam(value="userName") String userName) {
        Response response;
        String name = "(DISPO)" + programDescriptor.getName();
        if (!name.isEmpty()) {
            boolean isUniqueName = this.dispoApi.isUniqueProgramName(name);
            if (isUniqueName) {
                long createdProgramId = this.dispoApi.createDispoProgram(name, userName);
                Response.Status status = Response.Status.CREATED;
                response = Response.status((Response.Status)status).entity((Object)createdProgramId).build();
            } else {
                Response.Status status = Response.Status.CONFLICT;
                response = Response.status((Response.Status)status).entity((Object)"Can't create sets with the same name").build();
            }
        } else {
            Response.Status status = Response.Status.BAD_REQUEST;
            response = Response.status((Response.Status)status).entity((Object)"The Set must have a name and import path").build();
        }
        return response;
    }

    @Path(value="{name}")
    @POST
    @RolesAllowed(value={"dispoAdmin"})
    @Produces(value={"text/plain"})
    public Response createDispoProgramByName(@PathParam(value="name") String name, @QueryParam(value="userName") String userName) {
        DispoProgamDescriptorData programDescriptor = new DispoProgamDescriptorData();
        programDescriptor.setName(name);
        return this.createProgram(programDescriptor, userName);
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllPrograms() {
        List<BranchToken> allPrograms = this.dispoApi.getDispoPrograms();
        Collections.sort(allPrograms, new Comparator<BranchToken>(){

            @Override
            public int compare(BranchToken o1, BranchToken o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        LinkedList branchList = new LinkedList();
        for (BranchToken branch : allPrograms) {
            HashMap<String, String> mapObject = new HashMap<String, String>();
            String uuid = branch.getIdString();
            mapObject.put("value", uuid);
            mapObject.put("text", branch.getName());
            branchList.add(mapObject);
        }
        Response.Status status = allPrograms.isEmpty() ? Response.Status.NOT_FOUND : Response.Status.OK;
        String branchListJson = JsonUtil.toJson(branchList);
        return Response.status((Response.Status)status).entity((Object)branchListJson).build();
    }

    @Path(value="getDispoBranchId")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public String getDispoBranchId(@FormParam(value="name") String branchName) {
        return this.dispoApi.getDispoProgramIdByName(branchName).getIdString();
    }

    @Path(value="importAll")
    @PUT
    @RolesAllowed(value={"dispoAdmin"})
    @Consumes(value={"application/json"})
    public Response importAllDispoSets(String filterState) {
        this.dispoApi.importAllDispoPrograms(filterState, "OSEE System Auto-Import (All)");
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="importDispoBranch")
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response importDispoBranchByName(@FormParam(value="filterState") String filterState, @FormParam(value="name") String branchName) {
        BranchToken branch = this.dispoApi.getDispoProgramIdByName(branchName);
        this.dispoApi.importAllDispoSets((BranchId)branch, filterState, "OSEE System Auto-Import (Branch)");
        Response.Status status = Response.Status.OK;
        return Response.status((Response.Status)status).build();
    }

    @Path(value="{branchId}/set")
    public DispoSetResource getAnnotation(@PathParam(value="branchId") BranchId branch) {
        return new DispoSetResource(this.dispoApi, branch);
    }

    @Path(value="{branchId}/admin")
    public DispoAdminResource getDispoSetReport(@PathParam(value="branchId") BranchId branch) {
        return new DispoAdminResource(this.dispoApi, branch);
    }

    @Path(value="{branchId}/config")
    public DispoConfigResource getDispoDataStore(@PathParam(value="branchId") BranchId branch) {
        return new DispoConfigResource(this.dispoApi, branch);
    }
}

