/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureFilterEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceStructureFilterEndpointImpl
implements InterfaceStructureFilterEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfaceElementArrayApi interfaceElementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceStructureFilterEndpointImpl(BranchId branch, UserId account, ArtifactId messageId, ArtifactId subMessageId, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfaceElementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures() {
        List<InterfaceStructureToken> structureList = new LinkedList<InterfaceStructureToken>();
        try {
            structureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(structure);
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return structureList;
        }
    }

    private List<AttributeTypeId> createStructureAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceStructureCategory);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMinSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMaxSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceTaskFileType);
        return attributes;
    }

    private List<AttributeTypeId> createElementAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Notes);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexEnd);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexStart);
        return attributes;
    }

    private InterfaceStructureElementToken defaultSetUpElement(InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement) {
        try {
            PlatformTypeToken tempPlatformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
            element.setBeginByte((previousElement.getEndByte() + 1.0) % 4.0);
            element.setBeginWord(Math.floor(previousElement.getEndByte() == 3.0 ? previousElement.getEndWord() + 1.0 : previousElement.getEndWord()));
            element.setInterfacePlatformTypeBitSize(tempPlatformType.getInterfacePlatformTypeBitSize());
            element.setPlatformTypeId(tempPlatformType.getId());
            element.setPlatformTypeName(tempPlatformType.getName());
            element.setLogicalType(tempPlatformType.getInterfaceLogicalType() != null ? tempPlatformType.getInterfaceLogicalType() : "");
            element.setInterfacePlatformTypeMinval(tempPlatformType.getInterfacePlatformTypeMinval() != null ? tempPlatformType.getInterfacePlatformTypeMinval() : "");
            element.setInterfacePlatformTypeMaxval(tempPlatformType.getInterfacePlatformTypeMaxval() != null ? tempPlatformType.getInterfacePlatformTypeMaxval() : "");
            element.setInterfacePlatformTypeDefaultValue(tempPlatformType.getInterfacePlatformTypeDefaultValue() != null ? tempPlatformType.getInterfacePlatformTypeDefaultValue() : "");
            element.setUnits(tempPlatformType.getInterfacePlatformTypeUnits() != null ? tempPlatformType.getInterfacePlatformTypeUnits() : "");
        }
        catch (Exception exception) {}
        return element;
    }

    private InterfaceStructureToken parseStructure(InterfaceStructureToken structure) {
        try {
            LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
            elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
            LinkedList<InterfaceStructureElementToken> tempElements = new LinkedList<InterfaceStructureElementToken>();
            if (elements.size() >= 2) {
                Iterator elementIterator = elements.iterator();
                InterfaceStructureElementToken previousElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                InterfaceStructureElementToken currentElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                PlatformTypeToken previousPlatformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)previousElement.getId()), PlatformTypeToken.class);
                previousElement.setInterfacePlatformTypeBitSize(previousPlatformType.getInterfacePlatformTypeBitSize());
                previousElement.setBeginByte(0.0);
                previousElement.setBeginWord(0.0);
                previousElement.setPlatformTypeId(previousPlatformType.getId());
                previousElement.setPlatformTypeName(previousPlatformType.getName());
                previousElement.setLogicalType(previousPlatformType.getInterfaceLogicalType() != null ? previousPlatformType.getInterfaceLogicalType() : "");
                previousElement.setInterfacePlatformTypeMinval(previousPlatformType.getInterfacePlatformTypeMinval() != null ? previousPlatformType.getInterfacePlatformTypeMinval() : "");
                previousElement.setInterfacePlatformTypeMaxval(previousPlatformType.getInterfacePlatformTypeMaxval() != null ? previousPlatformType.getInterfacePlatformTypeMaxval() : "");
                previousElement.setInterfacePlatformTypeDefaultValue(previousPlatformType.getInterfacePlatformTypeDefaultValue() != null ? previousPlatformType.getInterfacePlatformTypeDefaultValue() : "");
                previousElement.setUnits(previousPlatformType.getInterfacePlatformTypeUnits() != null ? previousPlatformType.getInterfacePlatformTypeUnits() : "");
                tempElements.add(previousElement);
                if (!elementIterator.hasNext()) {
                    currentElement = this.defaultSetUpElement(currentElement, previousElement);
                }
                while (elementIterator.hasNext()) {
                    InterfaceStructureElementToken nextElement = (InterfaceStructureElementToken)((Object)elementIterator.next());
                    if ((currentElement = this.defaultSetUpElement(currentElement, previousElement)).getInterfacePlatformTypeByteSize() >= 4.0) {
                        if (previousElement.getEndByte() != 3.0) {
                            previousElement = new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", Math.floor((previousElement.getEndByte() + 1.0) % 4.0), previousElement.getEndWord(), (int)Math.floor(3.0 - previousElement.getEndByte()), true);
                            tempElements.add(previousElement);
                        }
                        if (currentElement.getInterfacePlatformTypeWordSize() > 1.0 && (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize() != 0.0) {
                            previousElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, previousElement.getEndWord() + 1.0, (int)(Math.floor(currentElement.getInterfacePlatformTypeWordSize() - (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize()) * 4.0) - 1);
                            tempElements.add(previousElement);
                        }
                        currentElement = this.defaultSetUpElement(currentElement, previousElement);
                    }
                    tempElements.add(currentElement);
                    previousElement = currentElement;
                    currentElement = nextElement;
                }
                if ((currentElement = this.defaultSetUpElement(currentElement, previousElement)).getInterfacePlatformTypeByteSize() >= 4.0) {
                    if (previousElement.getEndByte() != 3.0) {
                        previousElement = new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", Math.floor((previousElement.getEndByte() + 1.0) % 4.0), previousElement.getEndWord(), (int)Math.floor(3.0 - previousElement.getEndByte()), true);
                        tempElements.add(previousElement);
                    }
                    if (currentElement.getInterfacePlatformTypeWordSize() > 1.0 && (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize() != 0.0) {
                        previousElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, previousElement.getEndWord() + 1.0, (int)(Math.floor(currentElement.getInterfacePlatformTypeWordSize() - (previousElement.getEndWord() + 1.0) % currentElement.getInterfacePlatformTypeWordSize()) * 4.0) - 1);
                        tempElements.add(previousElement);
                    }
                    currentElement = this.defaultSetUpElement(currentElement, previousElement);
                }
                tempElements.add(currentElement);
                if (currentElement.getEndByte() != 3.0) {
                    tempElements.add(new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", currentElement.getEndByte() + 1.0, currentElement.getEndWord(), (int)Math.floor(3.0 - currentElement.getEndByte()), true));
                }
                if (currentElement.getEndWord() % 2.0 != 1.0) {
                    currentElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, currentElement.getEndWord() + 1.0, 3);
                    tempElements.add(currentElement);
                }
                structure.setElements(tempElements);
            } else {
                InterfaceStructureElementToken lastElement = new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", 0.0, 0.0, 0);
                for (InterfaceStructureElementToken element : elements) {
                    element.setBeginByte(0.0);
                    element.setBeginWord(0.0);
                    PlatformTypeToken currentPlatformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    element.setPlatformTypeId(currentPlatformType.getId());
                    element.setPlatformTypeName(currentPlatformType.getName());
                    element.setInterfacePlatformTypeBitSize(currentPlatformType.getInterfacePlatformTypeBitSize());
                    element.setLogicalType(currentPlatformType.getInterfaceLogicalType() != null ? currentPlatformType.getInterfaceLogicalType() : "");
                    element.setInterfacePlatformTypeMinval(currentPlatformType.getInterfacePlatformTypeMinval() != null ? currentPlatformType.getInterfacePlatformTypeMinval() : "");
                    element.setInterfacePlatformTypeMaxval(currentPlatformType.getInterfacePlatformTypeMaxval() != null ? currentPlatformType.getInterfacePlatformTypeMaxval() : "");
                    element.setInterfacePlatformTypeDefaultValue(currentPlatformType.getInterfacePlatformTypeDefaultValue() != null ? currentPlatformType.getInterfacePlatformTypeDefaultValue() : "");
                    element.setUnits(currentPlatformType.getInterfacePlatformTypeUnits() != null ? currentPlatformType.getInterfacePlatformTypeUnits() : "");
                    lastElement = element;
                }
                tempElements.addAll(elements);
                if (lastElement.getEndByte() != 3.0) {
                    tempElements.add(new InterfaceStructureElementToken("spare", "byte align spare for aligning to word start", lastElement.getEndByte() + 1.0, lastElement.getEndWord(), (int)Math.floor(3.0 - lastElement.getEndByte()), true));
                }
                if (lastElement.getEndWord() % 2.0 != 1.0) {
                    lastElement = new InterfaceStructureElementToken("spare", "byte align spare for byte alignment", 0.0, lastElement.getEndWord() + 1.0, 3);
                    tempElements.add(lastElement);
                }
                structure.setElements(tempElements);
            }
        }
        catch (Exception exception) {}
        return structure;
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures(String filter) {
        List<AttributeTypeId> structureAttributes = this.createStructureAttributeList();
        List<AttributeTypeId> elementAttributes = this.createElementAttributeList();
        List<InterfaceStructureToken> totalStructureList = new LinkedList<InterfaceStructureToken>();
        try {
            totalStructureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : totalStructureList) {
                structure = this.parseStructure(structure);
            }
            List structureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, filter, structureAttributes, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                structure = this.parseStructure(structure);
            }
            List elements = (List)this.interfaceElementApi.getAccessor().getAllByFilter(this.branch, filter, elementAttributes, InterfaceStructureElementToken.class);
            for (InterfaceStructureElementToken element : elements) {
                List subStructureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_DataElement, ArtifactId.valueOf((Long)element.getId()), InterfaceStructureToken.class);
                for (InterfaceStructureToken alternateStructure : subStructureList) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                    element.setLogicalType(platformType.getInterfaceLogicalType() != null ? platformType.getInterfaceLogicalType() : "");
                    element.setInterfacePlatformTypeMinval(platformType.getInterfacePlatformTypeMinval() != null ? platformType.getInterfacePlatformTypeMinval() : "");
                    element.setInterfacePlatformTypeMaxval(platformType.getInterfacePlatformTypeMaxval() != null ? platformType.getInterfacePlatformTypeMaxval() : "");
                    element.setInterfacePlatformTypeDefaultValue(platformType.getInterfacePlatformTypeDefaultValue() != null ? platformType.getInterfacePlatformTypeDefaultValue() : "");
                    element.setUnits(platformType.getInterfacePlatformTypeUnits() != null ? platformType.getInterfacePlatformTypeUnits() : "");
                    if (totalStructureList.indexOf((Object)alternateStructure) != -1 && totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)).getElements().indexOf((Object)element) != -1) {
                        InterfaceStructureElementToken tempElement = totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)).getElements().get(totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)).getElements().indexOf((Object)element));
                        element.setBeginByte(tempElement.getBeginByte());
                        element.setBeginWord(tempElement.getBeginWord());
                    }
                    LinkedList<InterfaceStructureElementToken> elementList = new LinkedList<InterfaceStructureElementToken>();
                    elementList.add(element);
                    alternateStructure.setElements(elementList);
                    if (totalStructureList.indexOf((Object)alternateStructure) == -1) continue;
                    totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure));
                    if (!structureList.contains((Object)alternateStructure)) {
                        structureList.add(alternateStructure);
                        continue;
                    }
                    InterfaceStructureToken tempStructure2 = (InterfaceStructureToken)((Object)structureList.get(structureList.indexOf((Object)alternateStructure)));
                    structureList.remove((Object)alternateStructure);
                    tempStructure2.getElements().add(element);
                    structureList.add(tempStructure2);
                }
            }
            return structureList;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return totalStructureList;
        }
    }
}

