/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.app;

import java.util.Collection;
import java.util.LinkedList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.osee.app.OseeAppTransfer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;

@Path(value="/api")
public final class OseeAppResource {
    private final OrcsApi orcsApi;

    public OseeAppResource(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<OseeAppTransfer> getOseeAppListJson(@QueryParam(value="filter") String filterText) {
        LinkedList<OseeAppTransfer> results = new LinkedList<OseeAppTransfer>();
        BranchId branchId = (BranchId)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andNameEquals("Common")).getResultsAsId().getExactlyOne();
        ResultSet apps = this.orcsApi.getQueryFactory().fromBranch(branchId).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.OseeApp}).getResults();
        for (ArtifactReadable art : apps) {
            String description = art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, "Not Available");
            String uuid = art.getIdString();
            if (filterText == null) {
                results.add(this.createTransfer(art.getName(), description, uuid));
                continue;
            }
            if (!description.matches(filterText)) continue;
            results.add(this.createTransfer(art.getName(), description, uuid));
        }
        return results;
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public String getOseeAppJson(@PathParam(value="id") ArtifactId id) {
        ArtifactReadable app = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(id).asArtifact();
        return app.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OseeAppDefinition);
    }

    private OseeAppTransfer createTransfer(String name, String description, String uuid) {
        OseeAppTransfer item = new OseeAppTransfer();
        item.setName(name);
        item.setDescription(description);
        item.setUuid(uuid);
        return item;
    }
}

