/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.ObjectType;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.criteria.CriteriaRelationTypeFollow;
import org.eclipse.osee.orcs.db.internal.search.handlers.SqlHandlerPriority;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlAliasManager;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;

public class RelationTypeFollowSqlHandler
extends SqlHandler<CriteriaRelationTypeFollow> {
    private CriteriaRelationTypeFollow criteria;
    private String artAlias0;
    private String txsAlias0;
    private String relAlias1;
    private String txsAlias1;
    private String artAlias2;
    private String txsAlias2;

    @Override
    public void setData(CriteriaRelationTypeFollow criteria) {
        this.criteria = criteria;
    }

    @Override
    public void addTables(AbstractSqlWriter writer) {
        List<String> artAliases = writer.getAliases(OseeDb.ARTIFACT_TABLE);
        if (artAliases.isEmpty()) {
            this.artAlias0 = writer.addTable(OseeDb.ARTIFACT_TABLE);
            this.txsAlias0 = writer.addTable(OseeDb.TXS_TABLE, ObjectType.ARTIFACT);
        } else {
            this.artAlias0 = artAliases.iterator().next();
        }
        this.relAlias1 = writer.addTable(OseeDb.RELATION_TABLE);
        this.txsAlias1 = writer.addTable(OseeDb.TXS_TABLE, ObjectType.RELATION);
        String branchAlias = writer.getFirstAlias(OseeDb.BRANCH_TABLE);
        SqlAliasManager aliasManager = writer.getAliasManager();
        aliasManager.nextLevel();
        this.artAlias2 = writer.addTable(OseeDb.ARTIFACT_TABLE);
        this.txsAlias2 = writer.addTable(OseeDb.TXS_TABLE, ObjectType.ARTIFACT);
        if (Strings.isValid((String)branchAlias)) {
            aliasManager.putAlias(OseeDb.BRANCH_TABLE, ObjectType.BRANCH, branchAlias);
        }
    }

    @Override
    public void addPredicates(AbstractSqlWriter writer) {
        boolean includeDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)writer.getOptions());
        RelationTypeSide typeSide = (RelationTypeSide)this.criteria.getType();
        if (this.txsAlias0 != null && this.artAlias0 != null) {
            writer.write(this.artAlias0);
            writer.write(".gamma_id = ");
            writer.write(this.txsAlias0);
            writer.write(".gamma_id");
            writer.write(" AND ");
            writer.writeTxBranchFilter(this.txsAlias0, includeDeletedRelations);
            writer.write("\n AND \n");
        }
        writer.write(this.relAlias1);
        writer.write(".rel_link_type_id = ?");
        writer.addParameter(typeSide.getGuid());
        String aOrbArtId = typeSide.getSide().isSideA() ? ".b_art_id" : ".a_art_id";
        writer.write(" AND ");
        writer.write(this.relAlias1);
        writer.write(aOrbArtId);
        writer.write(" = ");
        writer.write(this.artAlias0);
        writer.write(".art_id");
        writer.write(" AND ");
        writer.write(this.relAlias1);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias1);
        writer.write(".gamma_id");
        writer.write(" AND ");
        writer.writeTxBranchFilter(this.txsAlias1, includeDeletedRelations);
        String oppositeAOrBartId = typeSide.getSide().isSideA() ? ".a_art_id" : ".b_art_id";
        writer.write("\n AND \n");
        writer.write(this.relAlias1);
        writer.write(oppositeAOrBartId);
        writer.write(" = ");
        writer.write(this.artAlias2);
        writer.write(".art_id");
        writer.write(" AND ");
        writer.write(this.artAlias2);
        writer.write(".gamma_id = ");
        writer.write(this.txsAlias2);
        writer.write(".gamma_id");
        writer.write(" AND ");
        writer.writeTxBranchFilter(this.txsAlias2, includeDeletedRelations);
    }

    @Override
    public int getPriority() {
        return SqlHandlerPriority.FOLLOW_RELATION_TYPES.ordinal();
    }
}

