/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class CreateSystemBranches {
    private final OrcsApi orcsApi;
    private final TransactionFactory txFactory;
    private final QueryBuilder query;
    private static String EDIT_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String MERGE_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : false, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String PREVIEW_ALL_NO_ATTR_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : false, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String RECURSIVE_NO_ATTR_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : true, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"Word Template Content\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static String RECURSIVE_RENDERER_OPTIONS = "{\"ElementType\" : \"Artifact\", \"OutliningOptions\" : [ {\"Outlining\" : true, \"RecurseChildren\" : true, \"HeadingAttributeType\" : \"Name\", \"ArtifactName\" : \"Default\", \"OutlineNumber\" : \"\" }], \"AttributeOptions\" : [{\"AttrType\" : \"*\",  \"Label\" : \"\", \"FormatPre\" : \"\", \"FormatPost\" : \"\"}]}";
    private static final String JSON_ATTR_VALUE = "{ \"WCAFE\" : [{\"TypeId\" : 204509162766372, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 49}]},{\"TypeId\" : 204509162766372, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 99}, {\"Min\" : 1001, \"Max\" : 1009}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 50, \"Max\" : 199}]},{\"TypeId\" : 204509162766373, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 100, \"Max\" : 199}, {\"Min\" : 1100, \"Max\" : 1199}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766374, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 200, \"Max\" : 1000}, {\"Min\" : 1200, \"Max\" : 2000}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766370, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1, \"Max\" : 8191}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 1, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 61, \"Range\" : [{\"Min\" : 400}]},{\"TypeId\" : 204509162766371, \"BranchId\" : 714, \"Range\" : [{\"Min\" : 1}]}]}";
    private static final String JSON_PL_PREFERENCES = "{ \"FileExtensionCommentStyle\" : [\n      { \"FileExtension\" : \"fileApplicability\", \"CommentPrefixRegex\" : \"\", \"CommentSuffixRegex\" : \"\", \"CommentPrefix\" : \"\", \"CommentSuffix\" : \"\"},\n      { \"FileExtension\" : \"txt\", \"CommentPrefixRegex\" : \"\", \"CommentSuffixRegex\" : \"\", \"CommentPrefix\" : \"\", \"CommentSuffix\" : \"\"},\n      { \"FileExtension\" : \"VMF\", \"CommentPrefixRegex\" : \"%\", \"CommentPrefix\" : \"% \" },\n      { \"FileExtension\" : \"mdgsource\", \"CommentPrefixRegex\" : \"\\\\+\\\\.\", \"CommentPrefix\" : \"+. \" },\n      { \"FileExtension\" : \"java\", \"CommentPrefixRegex\" : \"/\\\\*\", \"CommentSuffixRegex\" : \"\\\\*/\", \"CommentPrefix\" : \"/* \", \"CommentSuffix\" : \" */\"},\n      { \"FileExtension\" : \"cpp\", \"CommentPrefixRegex\" : \"//\", \"CommentPrefix\" : \"// \" },\n      { \"FileExtension\" : \"cmd\", \"CommentPrefixRegex\" : \"REM\", \"CommentPrefix\" : \"REM \" },\n      { \"FileExtension\" : \"xml\", \"CommentPrefixRegex\" : \"<!--\", \"CommentSuffixRegex\" : \"-->\", \"CommentPrefix\" : \"<!-- \", \"CommentSuffix\" : \" -->\"},\n      { \"FileExtension\" : \"lst\", \"CommentPrefixRegex\" : \"#\", \"CommentPrefix\" : \"# \" }\n      ]}";

    public CreateSystemBranches(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.txFactory = orcsApi.getTransactionFactory();
        this.query = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
    }

    public TransactionId create(UserToken superUser) {
        this.orcsApi.getKeyValueOps().putByKey((Id)ApplicabilityToken.BASE, ApplicabilityToken.BASE.getName());
        this.populateSystemBranch();
        this.orcsApi.getBranchOps().createTopLevelBranch(CoreBranches.COMMON);
        return this.populateCommonBranch(superUser);
    }

    private void populateSystemBranch() {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.SYSTEM_ROOT, "Add System Root branch artifacts");
        tx.createArtifact(CoreArtifactTokens.DefaultHierarchyRoot);
        tx.createArtifact(CoreArtifactTokens.UniversalGroupRoot);
        tx.commit();
    }

    private TransactionId populateCommonBranch(UserToken superUser) {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, "Add Common branch artifacts");
        this.orcsApi.tokenService().getArtifactTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        this.orcsApi.tokenService().getAttributeTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        this.orcsApi.tokenService().getRelationTypeJoins().forEach(arg_0 -> ((TransactionBuilder)tx).addOrcsTypeJoin(arg_0));
        ArtifactReadable root = (ArtifactReadable)this.query.andIsHeirarchicalRootArtifact().getResults().getExactlyOne();
        ArtifactToken oseeConfig = tx.createArtifact((ArtifactId)root, CoreArtifactTokens.OseeConfiguration);
        ArtifactToken userGroupsFolder = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.UserGroups);
        ArtifactToken everyOne = tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.Everyone);
        tx.setSoleAttributeValue((ArtifactId)everyOne, (AttributeTypeToken)CoreAttributeTypes.DefaultGroup, (Object)true);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.AccountAdmin);
        tx.createArtifact((ArtifactId)userGroupsFolder, (ArtifactToken)CoreUserGroups.OseeAccessAdmin);
        ArtifactToken globalPreferences = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.GlobalPreferences);
        tx.setSoleAttributeValue((ArtifactId)globalPreferences, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)JSON_ATTR_VALUE);
        tx.setSoleAttributeValue((ArtifactId)globalPreferences, (AttributeTypeToken)CoreAttributeTypes.ProductLinePreferences, (Object)JSON_PL_PREFERENCES);
        tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.XViewerCustomization);
        ArtifactToken documentTemplateFolder = tx.createArtifact((ArtifactId)oseeConfig, CoreArtifactTokens.DocumentTemplates);
        this.createWordTemplates(tx, (ArtifactId)documentTemplateFolder);
        this.createDataRights(tx, (ArtifactId)documentTemplateFolder);
        tx.commit();
        List roles = superUser.getRoles();
        roles.add(CoreUserGroups.AccountAdmin);
        roles.add(CoreUserGroups.OseeAdmin);
        roles.add(CoreUserGroups.OseeAccessAdmin);
        UserToken userWithRoles = UserToken.create((long)superUser.getId(), (String)superUser.getName(), (String)superUser.getEmail(), (String)superUser.getUserId(), (boolean)true, (List)superUser.getLoginIds(), (List)roles);
        UserService userService = this.orcsApi.userService();
        userService.clearCaches();
        HashSet<UserToken> users = new HashSet<UserToken>(SystemUser.values());
        users.remove(userWithRoles);
        users.add(userWithRoles);
        TransactionId txId = userService.createUsers(users, "Create System Users");
        userService.setUserForCurrentThread((String)userWithRoles.getLoginIds().get(0));
        return txId;
    }

    private void createWordTemplates(TransactionBuilder tx, ArtifactId documentTemplateFolder) {
        ArtifactToken templateArtWe = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplateWholeWord, "WordEditTemplate");
        tx.setSoleAttributeValue((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)EDIT_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/Word Edit Template.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer SPECIALIZED_EDIT");
        tx.createAttribute((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.TisRenderer SPECIALIZED_EDIT");
        ArtifactToken templateArtMergeEdit = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplateWholeWord, "WordMergeTemplate");
        tx.setSoleAttributeValue((ArtifactId)templateArtWe, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)MERGE_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtMergeEdit, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtMergeEdit, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.word MERGE_EDIT");
        tx.createAttribute((ArtifactId)templateArtMergeEdit, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.word MERGE");
        tx.createAttribute((ArtifactId)templateArtMergeEdit, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer MERGE");
        tx.createAttribute((ArtifactId)templateArtMergeEdit, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer MERGE_EDIT");
        tx.createAttribute((ArtifactId)templateArtMergeEdit, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer DIFF THREE_WAY_MERGE");
        ArtifactToken templateArtPrev = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplateWholeWord, "PreviewAll");
        tx.setSoleAttributeValue((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_ARTIFACT");
        tx.createAttribute((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW");
        tx.createAttribute((ArtifactId)templateArtPrev, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer DIFF");
        ArtifactToken templateArtPrevNoAttr = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplateWholeWord, "PREVIEW_ALL_NO_ATTRIBUTES");
        tx.setSoleAttributeValue((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)PREVIEW_ALL_NO_ATTR_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL_NO_ATTRIBUTES.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_ALL_NO_ATTRIBUTES");
        tx.createAttribute((ArtifactId)templateArtPrevNoAttr, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer DIFF_NO_ATTRIBUTES");
        ArtifactToken templateArtPar = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplateWholeWord, "PREVIEW_ALL_RECURSE");
        tx.setSoleAttributeValue((ArtifactId)templateArtPar, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)RECURSIVE_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtPar, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL_RECURSE.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtPar, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_WITH_RECURSE");
        ArtifactToken templateArtParna = tx.createArtifact(documentTemplateFolder, CoreArtifactTypes.RendererTemplateWholeWord, "PREVIEW_ALL_RECURSE_NO_ATTRIBUTES");
        tx.setSoleAttributeValue((ArtifactId)templateArtParna, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)RECURSIVE_NO_ATTR_RENDERER_OPTIONS);
        tx.setSoleAttributeValue((ArtifactId)templateArtParna, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)OseeInf.getResourceContents((String)"templates/PREVIEW_ALL_RECURSE_NO_ATTRIBUTES.xml", this.getClass()));
        tx.createAttribute((ArtifactId)templateArtParna, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, (Object)"org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer PREVIEW PREVIEW_WITH_RECURSE_NO_ATTRIBUTES");
    }

    private void createDataRights(TransactionBuilder tx, ArtifactId documentTemplateFolder) {
        ArtifactToken dataRightsArt = tx.createArtifact(documentTemplateFolder, CoreArtifactTokens.DataRightsFooters);
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Unspecified.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Default.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"GovernmentPurposeRights.xml", this.getClass()));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"RestrictedRights.xml", this.getClass()));
    }
}

