/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskNameProviderToken;
import org.eclipse.osee.ats.api.task.create.IAtsChangeReportTaskNameProvider;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.task.AbstractAtsTaskServiceCore;
import org.eclipse.osee.ats.core.task.ChangeReportTaskNameProviderService;
import org.eclipse.osee.ats.core.task.CreateChangeReportTasksOperation;
import org.eclipse.osee.ats.core.task.CreateTasksOperation;
import org.eclipse.osee.ats.core.workflow.Task;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class AtsTaskService
extends AbstractAtsTaskServiceCore {
    public AtsTaskService(AtsApi atsApi) {
        super(atsApi);
    }

    public NewTaskSet createTasks(NewTaskSet newTaskSet, Map<Long, IAtsTeamWorkflow> idToTeamWf) {
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        CreateTasksOperation operation = new CreateTasksOperation(newTaskSet, this.atsApi);
        operation.setIdToTeamWf(idToTeamWf);
        NewTaskSet taskSet = operation.validate();
        if (taskSet.getResults().isSuccess()) {
            IAtsChangeSet changes = this.atsApi.createChangeSet(newTaskSet.getCommitComment());
            operation.run(changes);
            if (newTaskSet.getResults().isSuccess()) {
                for (JaxAtsTask task : operation.getTasks()) {
                    tasks.add(this.atsApi.getWorkItemService().getTask(this.atsApi.getQueryService().getArtifact(task.getId())));
                }
            }
        }
        return taskSet;
    }

    public NewTaskSet createTasks(NewTaskSet newTaskSet) {
        CreateTasksOperation operation = new CreateTasksOperation(newTaskSet, this.atsApi);
        operation.validate();
        if (newTaskSet.getResults().isErrors()) {
            throw new OseeStateException("Error validating task creation - " + newTaskSet.getResults().toString(), new Object[0]);
        }
        operation.run();
        if (newTaskSet.getResults().isErrors()) {
            throw new OseeStateException("Error creating tasks - " + newTaskSet.toString(), new Object[0]);
        }
        LinkedList<IAtsTask> tasks = new LinkedList<IAtsTask>();
        for (JaxAtsTask task : operation.getTasks()) {
            tasks.add(this.atsApi.getWorkItemService().getTask(this.atsApi.getQueryService().getArtifact(task.getId())));
        }
        return newTaskSet;
    }

    public ChangeReportTaskData createTasks(ChangeReportTaskData changeReportTaskData) {
        CreateChangeReportTasksOperation operation = new CreateChangeReportTasksOperation(changeReportTaskData, this.atsApi, null);
        return operation.run();
    }

    public IAtsChangeReportTaskNameProvider getChangeReportOptionNameProvider(ChangeReportTaskNameProviderToken token) {
        return ChangeReportTaskNameProviderService.getChangeReportOptionNameProvider((ChangeReportTaskNameProviderToken)token);
    }

    public IAtsTask getTask(ArtifactToken artifact) {
        if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
            throw new OseeArgumentException("Artifact %s must be of type Task", new Object[]{artifact.toStringWithId()});
        }
        return new Task(this.atsApi.getLogger(), this.atsApi, artifact);
    }
}

