/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.resources;

import java.net.URI;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.jaxrs.ApplicationInfo;
import org.eclipse.osee.jaxrs.JaxRsContributionInfo;
import org.eclipse.osee.jaxrs.server.internal.JaxRsResourceManager;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitable;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitor;
import org.osgi.framework.Bundle;

@Path(value="contributions")
public class JaxRsContributionsResource {
    private final JaxRsVisitable visitable;
    private final JaxRsResourceManager resourceManager;

    public JaxRsContributionsResource(JaxRsVisitable visitable, JaxRsResourceManager resourceManager) {
        this.visitable = visitable;
        this.resourceManager = resourceManager;
    }

    private String key(String bundleName, String bundleVersion) {
        return String.format("%s:%s", bundleName, bundleVersion);
    }

    private JaxRsContributionInfo getOrCreateInfo(Map<String, JaxRsContributionInfo> map, String bundleName, String bundleVersion) {
        String key = this.key(bundleName, bundleVersion);
        JaxRsContributionInfo info = map.get(key);
        if (info == null) {
            info = new JaxRsContributionInfo();
            info.setBundleName(bundleName);
            info.setVersion(bundleVersion);
            map.put(key, info);
        }
        return info;
    }

    private String getServletPath(UriInfo uriInfo) {
        String absolutePath = uriInfo.getAbsolutePath().toASCIIString();
        absolutePath = absolutePath.replaceAll("/jaxrs-admin/contributions", "");
        return absolutePath;
    }

    @PermitAll
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection<JaxRsContributionInfo> getContributionDetails(final @Context UriInfo uriInfo) {
        final HashMap contribs = new HashMap();
        this.visitable.accept(new JaxRsVisitor(){

            @Override
            public void onApplication(String applicationContext, String componentName, Bundle bundle, Application application) {
                Dictionary headers = bundle.getHeaders();
                String bundleName = (String)headers.get("Bundle-SymbolicName");
                String bundleVersion = (String)headers.get("Bundle-Version");
                JaxRsContributionInfo contrib = JaxRsContributionsResource.this.getOrCreateInfo(contribs, bundleName, bundleVersion);
                ApplicationInfo info = new ApplicationInfo();
                info.setName(componentName);
                String absolutePath = JaxRsContributionsResource.this.getServletPath(uriInfo);
                URI build = UriBuilder.fromPath((String)absolutePath).path(applicationContext).queryParam("_wadl", new Object[0]).build(new Object[0]);
                String path = build.toASCIIString();
                info.setUri(path);
                contrib.getApplications().add(info);
            }

            @Override
            public void onProvider(String componentName, Bundle bundle, Object provider) {
                Dictionary headers = bundle.getHeaders();
                String bundleName = (String)headers.get("Bundle-SymbolicName");
                String bundleVersion = (String)headers.get("Bundle-Version");
                JaxRsContributionInfo contrib = JaxRsContributionsResource.this.getOrCreateInfo(contribs, bundleName, bundleVersion);
                contrib.getProviders().add(componentName);
            }
        });
        this.resourceManager.accept(new JaxRsResourceManager.JaxRsResourceVisitor(){

            @Override
            public void onResource(Bundle bundle, Collection<String> resources) {
                Dictionary headers = bundle.getHeaders();
                String bundleName = (String)headers.get("Bundle-SymbolicName");
                String bundleVersion = (String)headers.get("Bundle-Version");
                JaxRsContributionInfo contrib = JaxRsContributionsResource.this.getOrCreateInfo(contribs, bundleName, bundleVersion);
                String absolutePath = JaxRsContributionsResource.this.getServletPath(uriInfo);
                Set staticResources = contrib.getStaticResources();
                for (String resource : resources) {
                    String uri = UriBuilder.fromPath((String)absolutePath).path(resource).build(new Object[0]).toASCIIString();
                    staticResources.add(uri);
                }
            }
        });
        return contribs.values();
    }
}

