/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.internal;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.ISession;
import org.eclipse.osee.framework.core.server.ISessionManager;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.server.ide.api.SessionEndpoint;

public class SessionEndpointImpl
implements SessionEndpoint {
    @Context
    private UriInfo uriInfo;
    private final IAuthenticationManager authenticationManager;
    private final ISessionManager sessionManager;
    private final ActivityLog activityLog;

    public SessionEndpointImpl(IAuthenticationManager authenticationManager, ISessionManager sessionManager, ActivityLog activityLog) {
        this.authenticationManager = authenticationManager;
        this.sessionManager = sessionManager;
        this.activityLog = activityLog;
    }

    public OseeSessionGrant createIdeClientSession(OseeCredential credential) {
        OseeSessionGrant sessionGrant = this.sessionManager.createSession(credential);
        if (sessionGrant != null) {
            this.logSessionCreation(credential, sessionGrant);
        }
        return sessionGrant;
    }

    public void releaseIdeClientSession(String sessionId) {
        this.logSessionReleased(sessionId);
        this.sessionManager.releaseSession(sessionId);
    }

    public List<String> getIdeClientProtocols() {
        LinkedList<String> protocols = new LinkedList<String>();
        String[] stringArray = this.authenticationManager.getProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String protocol = stringArray[n2];
            protocols.add(protocol);
            ++n2;
        }
        return protocols;
    }

    private void logSessionCreation(OseeCredential credential, OseeSessionGrant oseeSessionGrant) {
        try {
            this.activityLog.createEntry((UserId)oseeSessionGrant.getUserToken(), CoreActivityTypes.IDE, ActivityLog.COMPLETE_STATUS, new Object[]{String.format("IDE Client Session Created {\"version\":\"%s\", \"clientAddress\":\"%s\", \"clientMachineName\":\"%s\", \"port\":\"%s\", \"userName\":\"%s\", \"userId\":\"%s\", \"sessionId\":\"%s\"}", credential.getClientVersion(), credential.getClientAddress(), credential.getClientAddress(), credential.getClientPort(), credential.getUserName(), oseeSessionGrant.getUserToken().getUserId(), oseeSessionGrant.getSessionId())});
        }
        catch (Exception ex) {
            OseeLog.logf(this.getClass(), (Level)Level.SEVERE, (String)"Exception in logSessionCreated [%s]", (Object[])new Object[]{Lib.exceptionToString((Exception)ex)});
        }
    }

    private void logSessionReleased(String sessionId) {
        try {
            ISession session = this.sessionManager.getSessionById(sessionId);
            String duration = this.getDuration(session);
            String userId = session != null ? session.getUserId() : "unknown";
            this.activityLog.createEntry(CoreActivityTypes.IDE, ActivityLog.COMPLETE_STATUS, new Object[]{String.format("IDE Client Session Released {\"sessionId\":\"%s\", \"duration\":\"%s\", \"userId\":\"%s\"}", sessionId, duration, userId)});
        }
        catch (Exception ex) {
            OseeLog.logf(this.getClass(), (Level)Level.SEVERE, (String)"Exception in logSessionReleased [%s]", (Object[])new Object[]{Lib.exceptionToString((Exception)ex)});
        }
    }

    private String getDuration(ISession session) {
        String duration = "0";
        if (session != null) {
            duration = String.valueOf(new Date().getTime() - session.getCreationDate().getTime());
        }
        return duration;
    }
}

