/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OrcsTypeJoin;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.exception.OseeAccessDeniedException;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.DataStoreAdmin;
import org.eclipse.osee.orcs.core.internal.CreateDemoBranches;
import org.eclipse.osee.orcs.core.internal.CreateSystemBranches;
import org.eclipse.osee.orcs.core.internal.admin.FetchDatastoreMetadataCallable;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsAdminImpl
implements OrcsAdmin {
    private final OrcsApi orcsApi;
    private final Log logger;
    private final OrcsSession session;
    private final DataStoreAdmin dataStoreAdmin;
    private final QueryBuilder fromCommon;
    private final JdbcClient jdbcClient;

    public OrcsAdminImpl(OrcsApi orcsApi, Log logger, OrcsSession session, DataStoreAdmin dataStoreAdmin) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.session = session;
        this.dataStoreAdmin = dataStoreAdmin;
        this.fromCommon = orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        this.jdbcClient = dataStoreAdmin.getJdbcClient();
    }

    public TransactionId createDatastoreAndSystemBranches(UserToken superUser) {
        ActivityLog activityLog = this.orcsApi.getActivityLog();
        try {
            activityLog.setEnabled(false);
            this.dataStoreAdmin.createDataStore(superUser);
            TransactionId transactionId = new CreateSystemBranches(this.orcsApi).create(superUser);
            return transactionId;
        }
        finally {
            activityLog.setEnabled(true);
        }
    }

    public void registerMissingOrcsTypeJoins() {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "Add missing orcs type joins.");
        this.addMissingJoins(tx, CoreTupleTypes.ArtifactTypeJoin, this.orcsApi.tokenService().getArtifactTypeJoins());
        this.addMissingJoins(tx, CoreTupleTypes.AttributeTypeJoin, this.orcsApi.tokenService().getAttributeTypeJoins());
        this.addMissingJoins(tx, CoreTupleTypes.RelationTypeJoin, this.orcsApi.tokenService().getRelationTypeJoins());
        tx.commit();
    }

    private <J extends OrcsTypeJoin<J, T>, T extends NamedId> void addMissingJoins(TransactionBuilder tx, Tuple2Type<J, T> tupleType, Collection<J> registeredJoins) {
        ArrayList joinsInDb = new ArrayList();
        this.orcsApi.getQueryFactory().tupleQuery().getTuple2UniqueE1(tupleType, (BranchId)CoreBranches.COMMON, joinsInDb::add);
        for (OrcsTypeJoin join : registeredJoins) {
            if (joinsInDb.contains(join)) continue;
            tx.addOrcsTypeJoin(join);
        }
    }

    public void createSynonymsAndGrants() {
        for (String table : Arrays.asList("OSEE_ACCOUNT_SESSION", "OSEE_ACTIVITY", "OSEE_ACTIVITY_TYPE", "OSEE_ARTIFACT", "OSEE_ARTIFACT_ACL", "OSEE_ATTRIBUTE", "OSEE_BRANCH", "OSEE_BRANCH_ACL", "OSEE_CONFLICT", "OSEE_IMPORT_INDEX_MAP", "OSEE_IMPORT_MAP", "OSEE_IMPORT_SAVE_POINT", "OSEE_IMPORT_SOURCE", "OSEE_INFO", "OSEE_JOIN_ARTIFACT", "OSEE_JOIN_CHAR_ID", "OSEE_JOIN_CLEANUP", "OSEE_JOIN_EXPORT_IMPORT", "OSEE_JOIN_ID", "OSEE_JOIN_ID4", "OSEE_JOIN_TRANSACTION", "OSEE_KEY_VALUE", "OSEE_MERGE", "OSEE_OAUTH_AUTHORIZATION", "OSEE_OAUTH_CLIENT_CREDENTIAL", "OSEE_OAUTH_TOKEN", "OSEE_PERMISSION", "OSEE_RELATION_LINK", "OSEE_SCHEMA_VERSION", "OSEE_SEARCH_TAGS", "OSEE_SEQUENCE", "OSEE_SERVER_LOOKUP", "OSEE_SESSION", "OSEE_TAG_GAMMA_QUEUE", "OSEE_TUPLE2", "OSEE_TUPLE3", "OSEE_TUPLE4", "OSEE_BRANCH_CATEGORY", "OSEE_TXS", "OSEE_TXS_ARCHIVED", "OSEE_TX_DETAILS")) {
            try {
                this.jdbcClient.runCall("create public synonym " + table + " for " + table, new Object[0]);
            }
            catch (Exception exception) {
                XConsoleLogger.err((String)("Error creating synonym for table " + table), (Object[])new Object[0]);
            }
            try {
                this.jdbcClient.runCall("grant insert, update, delete, select on " + table + " to osee_client_role", new Object[0]);
            }
            catch (Exception exception) {
                XConsoleLogger.err((String)("Error granting permissions for table " + table), (Object[])new Object[0]);
            }
        }
    }

    public void createDemoBranches() {
        new CreateDemoBranches(this.orcsApi).populate();
    }

    public void configForDemoPl(BranchId branch) {
        CreateDemoBranches.createProductLineConfig(branch, this.orcsApi);
    }

    public Callable<OrcsMetaData> createFetchOrcsMetaData() {
        return new FetchDatastoreMetadataCallable(this.logger, this.session, this.dataStoreAdmin);
    }

    public boolean isDataStoreInitialized() {
        try {
            this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIds(new ArtifactId[]{CoreArtifactTokens.DefaultHierarchyRoot});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void requireRole(UserId user, ArtifactId role) {
        if (!this.fromCommon.andId(role).andRelatedTo(CoreRelationTypes.Users_User, role).exists()) {
            throw new OseeAccessDeniedException("User [%s] not in user group [%s]", new Object[]{user, role});
        }
    }

    public void changeArtifactTypeOutsideofHistory(ArtifactTypeId artifactType, List<? extends ArtifactId> artifacts) {
        String sql = "UPDATE osee_artifact SET art_type_id = ? WHERE art_id = ?";
        OseePreparedStatement batchStatement = this.jdbcClient.getBatchStatement(sql);
        artifacts.forEach(art -> batchStatement.addToBatch((Object)artifactType, art));
        batchStatement.execute();
    }
}

