/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.JsonArtifact;
import org.eclipse.osee.framework.core.data.JsonRelations;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.data.UpdateBranchData;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.rest.model.BranchCommitOptions;
import org.eclipse.osee.orcs.rest.model.BranchQueryData;
import org.eclipse.osee.orcs.rest.model.NewBranch;
import org.eclipse.osee.orcs.rest.model.NewTransaction;
import org.eclipse.osee.orcs.rest.model.Transaction;

@Path(value="branches")
public interface BranchEndpoint {
    @POST
    @Path(value="query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Branch> getBranches(BranchQueryData var1);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BranchId createBranch(NewBranch var1);

    @POST
    @Path(value="validation")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createBranchValidation(NewBranch var1);

    @GET
    @Produces(value={"application/json"})
    public List<Branch> getBranches(@DefaultValue(value="") @QueryParam(value="branchUuids") String var1, @DefaultValue(value="") @QueryParam(value="branchTypes") String var2, @DefaultValue(value="") @QueryParam(value="branchStates") String var3, @DefaultValue(value="false") @QueryParam(value="deleted") boolean var4, @DefaultValue(value="false") @QueryParam(value="archived") boolean var5, @DefaultValue(value="") @QueryParam(value="nameEquals") String var6, @DefaultValue(value="") @QueryParam(value="namePattern") String var7, @QueryParam(value="childOf") Long var8, @QueryParam(value="ancestorOf") Long var9, @QueryParam(value="category") BranchCategoryToken var10);

    @GET
    @Path(value="baseline")
    @Produces(value={"application/json"})
    public List<Branch> getBaselineBranches();

    @GET
    @Path(value="working")
    @Produces(value={"application/json"})
    public List<Branch> getWorkingBranches();

    @GET
    @Path(value="{branch}")
    @Produces(value={"application/json"})
    public Branch getBranchById(@PathParam(value="branch") BranchId var1);

    @GET
    @Path(value="category/{category}")
    @Produces(value={"application/json"})
    public List<Branch> getBranchesByCategory(@PathParam(value="category") BranchCategoryToken var1);

    @POST
    @Path(value="{branch}/category/{category}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData setBranchCategory(@PathParam(value="branch") BranchId var1, @PathParam(value="category") BranchCategoryToken var2);

    @DELETE
    @Path(value="{branch}/category/{category}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData deleteBranchCategory(@PathParam(value="branch") BranchId var1, @PathParam(value="category") BranchCategoryToken var2);

    @POST
    @Path(value="{branch}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public BranchId createBranchWithId(@PathParam(value="branch") BranchId var1, NewBranch var2);

    @POST
    @Path(value="{branch}/archive")
    public Response archiveBranch(@PathParam(value="branch") BranchId var1);

    @GET
    @Path(value="{branch}/artifact/type/{artifactTypes}/attributes")
    @Produces(value={"application/json"})
    public List<JsonArtifact> getArtifactDetailsByType(@PathParam(value="branch") BranchId var1, @PathParam(value="artifactTypes") String var2);

    @POST
    @Path(value="{branch}/commit/{destination-branch}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionResult commitBranch(@PathParam(value="branch") BranchId var1, @PathParam(value="destination-branch") BranchId var2, BranchCommitOptions var3);

    @GET
    @Path(value="{branch1}/diff/{branch2}")
    @Produces(value={"application/json"})
    public List<ChangeItem> compareBranches(@PathParam(value="branch1") BranchId var1, @PathParam(value="branch2") BranchId var2);

    @PUT
    @Path(value="{branch}/name")
    @Consumes(value={"text/plain"})
    public Response setBranchName(@PathParam(value="branch") BranchId var1, String var2);

    @POST
    @Path(value="{branch}/program")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public BranchToken createProgramBranch(@PathParam(value="branch") BranchId var1, String var2);

    @GET
    @Path(value="{branch}/relation/type/{relationTypes}")
    @Produces(value={"application/json"})
    public JsonRelations getRelationsByType(@PathParam(value="branch") BranchId var1, @PathParam(value="relationTypes") String var2);

    @PUT
    @Path(value="{branch}/state/{branch-state}")
    public Response setBranchState(@PathParam(value="branch") BranchId var1, @PathParam(value="branch-state") BranchState var2);

    @GET
    @Path(value="{branch}/txs")
    @Produces(value={"application/json"})
    public List<Transaction> getAllBranchTxs(@PathParam(value="branch") BranchId var1);

    @POST
    @Path(value="{branch}/txs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response writeTx(@PathParam(value="branch") BranchId var1, NewTransaction var2);

    @GET
    @Path(value="{branch}/txs/{tx-id}")
    @Produces(value={"application/json"})
    public Transaction getBranchTx(@PathParam(value="branch") BranchId var1, @PathParam(value="tx-id") TransactionId var2);

    @PUT
    @Path(value="{branch}/type/{branch-type}")
    public Response setBranchType(@PathParam(value="branch") BranchId var1, @PathParam(value="branch-type") BranchType var2);

    @GET
    @Path(value="{branch}/view/{viewId}/artifact/type/{artifactTypes}/attributes")
    @Produces(value={"application/json"})
    public List<JsonArtifact> getArtifactDetailsByType(@PathParam(value="branch") BranchId var1, @PathParam(value="viewId") ArtifactId var2, @PathParam(value="artifactTypes") String var3);

    @POST
    @Path(value="{branch}/update")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public UpdateBranchData updateBranch(@PathParam(value="branch") BranchId var1, UpdateBranchData var2);

    @POST
    @Path(value="{branch}/permission/{permission}/{subject}")
    public void setBranchPermission(@PathParam(value="subject") ArtifactId var1, @PathParam(value="branch") BranchId var2, @PathParam(value="permission") PermissionEnum var3);

    @PUT
    @Path(value="{branch}/associated-artifact/{art-id}")
    public Response associateBranchToArtifact(@PathParam(value="branch") BranchId var1, @PathParam(value="art-id") ArtifactId var2);

    @PUT
    @Path(value="{branch}/txs/{tx-id}/comment")
    @Consumes(value={"text/plain"})
    public Response setTxComment(@PathParam(value="branchd") BranchId var1, @PathParam(value="tx-id") TransactionId var2, String var3);

    @DELETE
    @Path(value="{branch}")
    public Response purgeBranch(@PathParam(value="branch") BranchId var1, @DefaultValue(value="false") @QueryParam(value="recurse") boolean var2);

    @DELETE
    @Path(value="{branch}/associated-artifact")
    public Response unassociateBranch(@PathParam(value="branch") BranchId var1);

    @DELETE
    @Path(value="{branch}/commit/{destination-branch}")
    @Produces(value={"application/json"})
    public Response unCommitBranch(@PathParam(value="branch") BranchId var1, @PathParam(value="destination-branch") BranchId var2);

    @DELETE
    @Path(value="{branch}/archive")
    @Produces(value={"application/json"})
    public Response unarchiveBranch(@PathParam(value="branch") BranchId var1);

    @DELETE
    @Path(value="{branch}/txs/{tx-ids}")
    public Response purgeTxs(@PathParam(value="branch") BranchId var1, @PathParam(value="tx-ids") String var2);

    @PUT
    @Path(value="log")
    @Consumes(value={"text/plain"})
    public Response logBranchActivity(String var1);

    @GET
    @Path(value="{branchId}/other-mods/{art-id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getOtherBranchesWithModifiedArtifacts(@PathParam(value="branchId") BranchId var1, @PathParam(value="art-id") ArtifactId var2);
}

