/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.report;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.report.AbstractArtifactRelationReport;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class ArtifactTraceCount
extends AbstractArtifactRelationReport {
    public String[] getHeader() {
        ArrayList<String> header = new ArrayList<String>();
        header.add("Name");
        header.add("Type");
        RelationTypeSide[] relationTypeSideArray = this.getRelationsToCheck();
        int n = relationTypeSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationTypeSide relation = relationTypeSideArray[n2];
            header.add(String.valueOf(relation.getName()) + " Trace Count");
            ++n2;
        }
        header.add("Subsystem");
        return header.toArray(new String[header.size()]);
    }

    private AttributeTypeId getSubsystemAttributeType(Artifact artifact) {
        for (AttributeTypeId attributeType : artifact.getAttributeTypes()) {
            if (attributeType.equals(CoreAttributeTypes.Partition)) {
                return CoreAttributeTypes.Partition;
            }
            if (!attributeType.equals(CoreAttributeTypes.CSCI)) continue;
            return CoreAttributeTypes.CSCI;
        }
        return null;
    }

    @Override
    public void process(IProgressMonitor monitor) {
        String[] header = this.getHeader();
        this.notifyOnTableHeader(header);
        RelationTypeSide[] relations = this.getRelationsToCheck();
        Artifact[] artifactArray = this.getArtifactsToCheck();
        int n = artifactArray.length;
        int n2 = 0;
        while (n2 < n) {
            Artifact art = artifactArray[n2];
            String[] rowData = new String[header.length];
            int index = 0;
            rowData[index++] = art.getName();
            rowData[index++] = art.getArtifactTypeName();
            RelationTypeSide[] relationTypeSideArray = relations;
            int n3 = relations.length;
            int n4 = 0;
            while (n4 < n3) {
                RelationTypeSide relationType = relationTypeSideArray[n4];
                rowData[index++] = String.valueOf(art.getRelatedArtifactsCount(relationType));
                ++n4;
            }
            AttributeTypeId attributeType = this.getSubsystemAttributeType(art);
            rowData[index++] = attributeType == null ? "Unspecified" : Collections.toString((String)",", (Iterable)art.getAttributesToStringList(attributeType));
            this.notifyOnRowData(art, rowData);
            ++n2;
        }
        this.notifyOnEndTable();
    }
}

