/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.services.IOseeCachingService;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.ArtifactReferenceAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.BooleanAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.BranchReferenceAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.CompressedContentAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.DateAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.EnumeratedAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.FloatingPointAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.IntegerAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.LongAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.OutlineNumberAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.StringAttribute;
import org.eclipse.osee.framework.skynet.core.attribute.providers.DefaultAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.IAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.attribute.providers.UriAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;

public class AttributeTypeManager {
    private static IOseeCachingService getCacheService() {
        return ServiceUtil.getOseeCacheService();
    }

    public static OrcsTokenService getTokenService() {
        return AttributeTypeManager.getCacheService().getTokenService();
    }

    public static Collection<AttributeTypeToken> getValidAttributeTypes(BranchId branch) {
        HashSet<AttributeTypeToken> attributeTypes = new HashSet<AttributeTypeToken>(100);
        for (ArtifactTypeToken artifactType : AttributeTypeManager.getCacheService().getTokenService().getArtifactTypes()) {
            attributeTypes.addAll(artifactType.getValidAttributeTypes());
        }
        return attributeTypes;
    }

    public static Collection<AttributeTypeGeneric<?>> getAllTypes() {
        return AttributeTypeManager.getTokenService().getAttributeTypes();
    }

    public static Collection<AttributeTypeToken> getTaggableTypes() {
        ArrayList<AttributeTypeToken> taggableTypes = new ArrayList<AttributeTypeToken>();
        for (AttributeTypeToken attributeTypeToken : AttributeTypeManager.getAllTypes()) {
            if (!attributeTypeToken.isTaggable()) continue;
            taggableTypes.add(attributeTypeToken);
        }
        return taggableTypes;
    }

    public static Set<AttributeTypeToken> getSingleMultiplicityTypes() {
        return AttributeTypeManager.getTokenService().getSingletonAttributeTypes();
    }

    public static boolean typeExists(String name) {
        return AttributeTypeManager.getTokenService().attributeTypeExists(name);
    }

    public static AttributeTypeGeneric<?> getAttributeType(Long id) {
        return AttributeTypeManager.getTokenService().getAttributeType(id);
    }

    public static AttributeTypeToken getType(String name) {
        return AttributeTypeManager.getTokenService().getAttributeType(name);
    }

    public static Class<? extends Attribute<?>> getAttributeBaseClass(AttributeTypeId attributeType) {
        AttributeTypeGeneric attributeTypeToken = AttributeTypeManager.getTokenService().getAttributeType(attributeType.getId());
        if (attributeTypeToken.isInputStream()) {
            return CompressedContentAttribute.class;
        }
        if (attributeTypeToken.isBoolean()) {
            return BooleanAttribute.class;
        }
        if (attributeTypeToken.isDate()) {
            return DateAttribute.class;
        }
        if (attributeTypeToken.isDouble()) {
            return FloatingPointAttribute.class;
        }
        if (attributeTypeToken.isArtifactId()) {
            return ArtifactReferenceAttribute.class;
        }
        if (attributeTypeToken.isBranchId()) {
            return BranchReferenceAttribute.class;
        }
        if (attributeTypeToken.isInteger()) {
            return IntegerAttribute.class;
        }
        if (attributeTypeToken.isLong()) {
            return LongAttribute.class;
        }
        if (attributeTypeToken.isString()) {
            return StringAttribute.class;
        }
        if (attributeTypeToken.isEnumerated()) {
            return EnumeratedAttribute.class;
        }
        if (attributeTypeToken.equals(CoreAttributeTypes.ParagraphNumber)) {
            return OutlineNumberAttribute.class;
        }
        return StringAttribute.class;
    }

    public static <T> IAttributeDataProvider getAttributeProvider(Long attributeTypeId, Attribute<T> attribute) {
        AttributeTypeGeneric<?> attributeType = AttributeTypeManager.getAttributeType(attributeTypeId);
        if (attributeType.isUri()) {
            return new UriAttributeDataProvider((Attribute<?>)attribute);
        }
        return new DefaultAttributeDataProvider<T>(attribute);
    }

    public static boolean checkIfRemovalAllowed(AttributeTypeToken attributeType, Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (artifact.getArtifactType().getMin(attributeType) <= 0) continue;
            return false;
        }
        return true;
    }
}

