/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.hooks;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.DecisionReviewOption;
import org.eclipse.osee.ats.api.review.DecisionReviewOptions;
import org.eclipse.osee.ats.api.review.DecisionReviewState;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.hooks.IAtsWorkItemHookIde;
import org.eclipse.osee.ats.ide.workflow.review.DecisionReviewArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboDam;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AtsDecisionReviewDecisionWorkItemHookIde
implements IAtsWorkItemHookIde,
IAtsTransitionHook {
    public String getName() {
        return AtsDecisionReviewDecisionWorkItemHookIde.class.getSimpleName();
    }

    public String getDescription() {
        return "Add decision options to Decision state based on prepare state's entries.";
    }

    @Override
    public Result xWidgetCreating(XWidget xWidget, FormToolkit toolkit, IAtsStateDefinition stateDefinition, Artifact art, boolean isEditable) {
        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.DecisionReview}) && stateDefinition.getName().equals(DecisionReviewState.Decision.getName())) {
            if (xWidget == null) {
                throw new OseeStateException("Can't retrieve decision review combo widget to set.", new Object[0]);
            }
            if (xWidget.getLabel().equals(AtsAttributeTypes.Decision.getUnqualifiedName())) {
                XComboDam decisionComboDam = (XComboDam)xWidget;
                DecisionReviewOptions xDecOptions = new DecisionReviewOptions((IAtsDecisionReview)art, (AtsApi)AtsApiService.get());
                decisionComboDam.setDataStrings(Named.getNamesArray((Collection)xDecOptions.getDecisionOptions()));
            }
        }
        return Result.TrueResult;
    }

    public String getOverrideTransitionToStateName(IAtsWorkItem workItem) {
        WorkflowEditor editor;
        if (this.isApplicable(workItem) && (editor = WorkflowEditor.getWorkflowEditor(workItem)) != null) {
            if (editor.getWorkFlowTab().getHeader().getWfeTransitionHeader() == null) {
                return null;
            }
            if (editor.getWorkFlowTab().getHeader().getWfeTransitionHeader().isSelected()) {
                return null;
            }
            XWidget xWidget = editor.getWorkFlowTab().getCurrentStateSection().getPage().getLayoutData(AtsAttributeTypes.Decision.getUnqualifiedName()).getXWidget();
            XComboDam decisionComboDam = (XComboDam)xWidget;
            DecisionReviewArtifact decArt = (DecisionReviewArtifact)workItem;
            return this.getOverrideTransitionToStateName(decArt, decisionComboDam);
        }
        return null;
    }

    private boolean isApplicable(IAtsWorkItem workItem) {
        return workItem.isTypeEqual((ArtifactTypeId)AtsArtifactTypes.DecisionReview) && workItem.getStateMgr().getCurrentStateName().equals(DecisionReviewState.Decision.getName());
    }

    public String getOverrideTransitionToStateName(DecisionReviewArtifact decArt, XComboDam decisionComboDam) {
        DecisionReviewOption decisionOption = this.getDecisionOption(decArt, decisionComboDam.get());
        if (decisionOption == null) {
            return null;
        }
        boolean followUpRequired = decisionOption.isFollowupRequired();
        if (followUpRequired) {
            return DecisionReviewState.Followup.getName();
        }
        return DecisionReviewState.Completed.getName();
    }

    public Collection<AtsUser> getOverrideTransitionToAssignees(IAtsWorkItem workItem, String decision) {
        if (this.isApplicable(workItem)) {
            DecisionReviewArtifact decArt = (DecisionReviewArtifact)workItem;
            return this.getOverrideTransitionToAssignees(decArt, decision);
        }
        return null;
    }

    public Collection<AtsUser> getOverrideTransitionToAssignees(DecisionReviewArtifact decArt, String decision) {
        DecisionReviewOption decisionOption = this.getDecisionOption(decArt, decision);
        if (decisionOption == null) {
            return null;
        }
        LinkedList<AtsUser> assignees = new LinkedList<AtsUser>();
        assignees.addAll(AtsApiService.get().getUserService().getUsersByUserIds(decisionOption.getAssignees()));
        return assignees;
    }

    private DecisionReviewOption getDecisionOption(DecisionReviewArtifact decRevArt, String decision) {
        if (decision.equals("")) {
            return null;
        }
        return decRevArt.decisionOptions.getDecisionOption(decision);
    }
}

