/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.agile.AgileUtil;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;

public class WorkItemTypeSearchWidget {
    private final WorldEditorParameterSearchItem searchItem;
    private boolean reviewSearch;

    public WorkItemTypeSearchWidget(WorldEditorParameterSearchItem searchItem) {
        this.searchItem = searchItem;
    }

    public void addWidget(int beginComposite) {
        if (this.reviewSearch) {
            this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Peer Review\" labelAfter=\"true\" horizontalLabel=\"true\" beginComposite=\"6\"/>");
            this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Decision Review\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        } else {
            this.searchItem.addWidgetXml(String.format("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Team Workflow\" defaultValue=\"true\" labelAfter=\"true\" horizontalLabel=\"true\" %s />", this.searchItem.getBeginComposite(beginComposite)));
            this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Task\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
            this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Peer Review\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
            this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Decision Review\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
            if (AgileUtil.isAgileUser((AtsApi)AtsApiService.get())) {
                this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Goal\" labelAfter=\"true\" horizontalLabel=\"true\"/>");
                this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Agile Sprint\" labelAfter=\"true\" horizontalLabel=\"true\" />");
                this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Agile Backlog\" labelAfter=\"true\" horizontalLabel=\"true\" endComposite=\"true\" />");
            } else {
                this.searchItem.addWidgetXml("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Goal\" labelAfter=\"true\" horizontalLabel=\"true\" endComposite=\"true\"/>");
            }
        }
    }

    public XCheckBox getWidget(String workItemType) {
        return (XCheckBox)this.searchItem.getxWidgets().get(workItemType);
    }

    public XCheckBox getWidget(WorkItemType type) {
        return this.getWidget(type.getDisplayName());
    }

    public void set(WorkItemType type, boolean selected) {
        this.set(type.getDisplayName(), selected);
    }

    public void set(String workItemType, boolean selected) {
        XCheckBox checkbox = this.getWidget(workItemType);
        if (checkbox != null) {
            checkbox.set(selected);
        }
    }

    public Collection<WorkItemType> get() {
        ArrayList<WorkItemType> types = new ArrayList<WorkItemType>();
        if (this.isReviewSearch()) {
            this.addTypeIfChecked(types, WorkItemType.PeerReview);
            this.addTypeIfChecked(types, WorkItemType.DecisionReview);
        } else {
            this.addTypeIfChecked(types, WorkItemType.TeamWorkflow);
            this.addTypeIfChecked(types, WorkItemType.Task);
            this.addTypeIfChecked(types, WorkItemType.PeerReview);
            this.addTypeIfChecked(types, WorkItemType.DecisionReview);
            this.addTypeIfChecked(types, WorkItemType.Goal);
            this.addTypeIfChecked(types, WorkItemType.AgileSprint);
            this.addTypeIfChecked(types, WorkItemType.AgileBacklog);
        }
        return types;
    }

    private void addTypeIfChecked(List<WorkItemType> types, WorkItemType workItemType) {
        XCheckBox widget = this.getWidget(workItemType.getDisplayName());
        if (widget != null && widget.isChecked()) {
            types.add(workItemType);
        }
    }

    public void clearAll() {
        WorkItemType[] workItemTypeArray = WorkItemType.values();
        int n = workItemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemType type = workItemTypeArray[n2];
            XCheckBox widget = this.getWidget(type);
            if (widget != null) {
                widget.set(false);
            }
            ++n2;
        }
    }

    public void set(AtsSearchData data) {
        if (data.getWorkItemTypes() != null && !data.getWorkItemTypes().isEmpty()) {
            for (WorkItemType type : data.getWorkItemTypes()) {
                this.set(type, true);
            }
        }
    }

    public boolean isReviewSearch() {
        return this.reviewSearch;
    }

    public void setReviewSearch(boolean reviewSearch) {
        this.reviewSearch = reviewSearch;
    }
}

