/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.util.OseeEmail;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.notify.OseeEmailIde;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class TestEmailSend
extends XNavigateItemAction {
    AtsApi atsApi = AtsApiService.get();

    public TestEmailSend() {
        super("Test Email Send", (KeyedImage)FrameworkImage.EMAIL, new XNavItemCat[]{XNavigateItem.EMAIL_NOTIFICATIONS});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        block6: {
            try {
                XResultData rd = new XResultData();
                rd.log("Send Test Email");
                User user = UserManager.getUser();
                if (user.isInvalid()) {
                    rd.errorf("User [%s] is invalid", new Object[]{user});
                    break block6;
                }
                String email = user.getEmail();
                if (!EmailUtil.isEmailValid((String)email)) {
                    rd.errorf("User email [%s] is invalid", new Object[]{user});
                    XResultDataUI.report((XResultData)rd, (String)"Test Email");
                    return;
                }
                rd = new XResultData();
                rd.log("Send Test Email - Client");
                try {
                    OseeEmailIde emailMessage = OseeEmailIde.create(Arrays.asList(email), (String)email, (String)email, (String)"Test Email - Client", (String)AHTML.simplePage((String)AHTML.bold((String)"Hello World - this should be bold")), (OseeEmail.BodyType)OseeEmail.BodyType.Html);
                    emailMessage.send();
                    rd.log("Completed");
                }
                catch (Exception ex) {
                    rd.error(Lib.exceptionToString((Exception)ex));
                }
                XResultDataUI.report((XResultData)rd, (String)"Send Test Email - Client");
                rd = this.atsApi.getServerEndpoints().getNotifyEndpoint().sendEmail(email);
                rd.log("Completed");
                XResultDataUI.report((XResultData)rd, (String)"Send Test Email - Server");
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }
}

