/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfeAttachmentsComposite
extends Composite {
    private final WorkflowEditor editor;
    private final IAtsWorkItem workItem;
    private final Map<Long, Composite> relIdToComp = new HashMap<Long, Composite>();
    private final Set<Long> existingRels = new HashSet<Long>();
    private final AtsApi atsApi;
    private Label label;

    public WfeAttachmentsComposite(Composite parent, int style, WorkflowEditor editor) {
        super(parent, style);
        this.editor = editor;
        this.workItem = editor.getWorkItem();
        this.atsApi = AtsApiService.get();
    }

    public void create() {
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)1, (boolean)false));
        GridData gd = new GridData(768);
        this.setLayoutData(gd);
        this.editor.getToolkit().adapt((Composite)this);
        this.label = new Label((Composite)this, 0);
        this.label.setText("No Attachments");
        this.label.setBackground(Displays.getSystemColor((int)1));
        this.label.setFont(FontManager.getDefaultLabelFont());
        this.createUpdateAttached();
        this.refresh();
        this.layout(true, true);
        this.getParent().layout(true, true);
        this.editor.getWorkFlowTab().getManagedForm().reflow(true);
    }

    private void createUpdateAttached() {
        Map<RelationLink, Artifact> supporting = this.getSupporting();
        ArrayList<Long> linkHandled = new ArrayList<Long>();
        this.existingRels.addAll(this.relIdToComp.keySet());
        for (Map.Entry<RelationLink, Artifact> supportEntry : supporting.entrySet()) {
            if (linkHandled.contains(supportEntry.getKey().getId())) continue;
            try {
                RelationLink relation = supportEntry.getKey();
                if (this.existingRels.contains(relation.getId())) {
                    this.existingRels.remove(relation.getId());
                    continue;
                }
                Artifact support = supportEntry.getValue();
                String labelStr = support.toStringWithId();
                if (support instanceof IAtsWorkItem) {
                    IAtsWorkItem thatWorkItem = (IAtsWorkItem)support;
                    labelStr = String.format("[%s] - %s - [%s]", thatWorkItem.getArtifactTypeName(), thatWorkItem.toStringWithAtsId(), thatWorkItem.getStateMgr().getCurrentStateName());
                }
                Composite lComp = new Composite((Composite)this, 0);
                this.relIdToComp.put(relation.getId(), lComp);
                lComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)5, (boolean)false));
                GridData gd = new GridData(768);
                lComp.setLayoutData((Object)gd);
                this.editor.getToolkit().adapt(lComp);
                lComp.setBackground(Displays.getSystemColor((int)1));
                this.editor.getToolkit().createLabel(lComp, "    - " + labelStr);
                Artifact thisArt = (Artifact)this.workItem.getStoreObject();
                Artifact thatArt = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)support);
                WfeAttachmentsComposite.createReadHyperlink(thisArt, thatArt, lComp, this.editor, "Open");
                WfeAttachmentsComposite.createEditHyperlink(thatArt, lComp, this.editor);
                WfeAttachmentsComposite.createDeleteHyperlink(thisArt, thatArt, relation, lComp, this.editor);
                linkHandled.add(supportEntry.getKey().getId());
                this.label.setText("Attachments: ");
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.WARNING, (String)("Error showing link " + supportEntry.getKey()), (Throwable)ex);
            }
        }
        if (!this.existingRels.isEmpty()) {
            this.removeRelations(this.existingRels);
        }
    }

    private Map<RelationLink, Artifact> getSupporting() {
        HashSet supportingLink = new HashSet();
        supportingLink.addAll(this.atsApi.getRelationResolver().getRelations((ArtifactId)this.workItem.getStoreObject(), CoreRelationTypes.SupportingInfo_SupportingInfo));
        supportingLink.addAll(this.atsApi.getRelationResolver().getRelations((ArtifactId)this.workItem.getStoreObject(), CoreRelationTypes.SupportingInfo_IsSupportedBy));
        HashMap<RelationLink, Artifact> supporting = new HashMap<RelationLink, Artifact>();
        for (IRelationLink iLink : supportingLink) {
            Artifact otherArt;
            RelationLink link = (RelationLink)iLink;
            if (this.workItem.getId().equals(link.getArtifactA().getId())) {
                otherArt = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)link.getArtifactB());
                supporting.put(link, otherArt);
                continue;
            }
            otherArt = (Artifact)this.atsApi.getQueryService().getArtifact((ArtifactId)link.getArtifactA());
            supporting.put(link, otherArt);
        }
        return supporting;
    }

    private void removeRelations(final Set<Long> existingRels) {
        final WfeAttachmentsComposite fComp = this;
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)fComp) && WfeAttachmentsComposite.this.relIdToComp != null) {
                    for (Long relationId : existingRels) {
                        Composite comp = (Composite)WfeAttachmentsComposite.this.relIdToComp.get(relationId);
                        if (comp == null) continue;
                        comp.dispose();
                    }
                }
            }
        });
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this)) {
            this.createUpdateAttached();
        }
    }

    public static Hyperlink createDeleteHyperlink(final Artifact thisArt, final Artifact thatArt, final RelationLink relation, Composite lComp, WorkflowEditor editor) {
        Hyperlink link = editor.getToolkit().createHyperlink(lComp, "Delete", 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IAtsChangeSet changes;
                Artifact delArt = thatArt;
                if (thatArt instanceof IAtsWorkItem) {
                    delArt = thisArt;
                }
                List<ArtifactToken> related = Arrays.asList(thatArt);
                if (thatArt instanceof IAtsObject) {
                    if (MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Delete Related", (String)"You do not have permissions to delete ATS Objects.  Would you Like to Un-Relate?")) {
                        IAtsChangeSet changes2 = AtsApiService.get().createChangeSet("Delete Relation");
                        changes2.deleteRelation((RelationId)relation);
                        changes2.execute();
                    }
                    return;
                }
                XResultData results = AtsApiService.get().getAccessControlService().isDeleteable(related, new XResultData());
                if (results.isErrors()) {
                    AWorkbench.popup((String)results.toString());
                    return;
                }
                int result = MessageDialog.open((int)5, (Shell)Displays.getActiveShell(), (String)"Delete/Un-Relate Related", (String)("WARNING: You can DELETE or UN-RELATE...\n\n" + delArt.toStringWithId() + "\n\n" + "If you DELETE, this artifact will be REMOVED from the database.\n\n" + "If you UN-RELATE, this artifact will be un-related, but will remain in the database."), (int)0, (String[])new String[]{"Un-Relate this Artifact", "DELETE this Artifact", "Cancel"});
                if (result == 0) {
                    changes = AtsApiService.get().createChangeSet("Un-Relate Artifact");
                    changes.deleteRelation((RelationId)relation);
                    changes.execute();
                }
                if (result == 1) {
                    changes = AtsApiService.get().createChangeSet("Delete Related Artifact");
                    changes.deleteArtifact((ArtifactId)delArt);
                    changes.execute();
                }
            }
        });
        return link;
    }

    public static Hyperlink createEditHyperlink(final Artifact thatArt, Composite lComp, WorkflowEditor editor) {
        Hyperlink link = editor.getToolkit().createHyperlink(lComp, "Edit", 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (AtsObjects.isAtsWorkItemOrAction((Object)thatArt)) {
                    AtsEditors.openATSAction((ArtifactToken)thatArt, AtsOpenOption.OpenOneOrPopupSelect);
                } else {
                    try {
                        RendererManager.open((Artifact)thatArt, (PresentationType)PresentationType.SPECIALIZED_EDIT);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            }
        });
        return link;
    }

    public static Hyperlink createReadHyperlink(Artifact thisArt, final Artifact thatArt, Composite lComp, WorkflowEditor editor, String label) {
        Hyperlink link = editor.getToolkit().createHyperlink(lComp, label, 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (AtsObjects.isAtsWorkItemOrAction((Object)thatArt)) {
                    AtsEditors.openATSAction((ArtifactToken)thatArt, AtsOpenOption.OpenOneOrPopupSelect);
                } else {
                    try {
                        RendererManager.open((Artifact)thatArt, (PresentationType)PresentationType.DEFAULT_OPEN);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            }
        });
        return link;
    }
}

