/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.ats.ide.util.widgets.dialog.VersionListDialog;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class ReleaseVersionItem
extends XNavigateItemAction {
    public static String[] strs = new String[0];
    private final IAtsTeamDefinition teamDefHoldingVersions;

    public ReleaseVersionItem(IAtsTeamDefinition teamDefHoldingVersions) {
        this(teamDefHoldingVersions, AtsNavigateViewItems.ATS_VERSIONS_ADMIN);
    }

    public ReleaseVersionItem(IAtsTeamDefinition teamDefHoldingVersions, XNavItemCat xNavItemCat) {
        super("Release " + (teamDefHoldingVersions != null ? teamDefHoldingVersions + " " : "") + "Version (Admin)", (KeyedImage)FrameworkImage.VERSION, new XNavItemCat[]{xNavItemCat});
        this.teamDefHoldingVersions = teamDefHoldingVersions;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        IAtsTeamDefinition teamDefHoldingVersions = this.getReleaseableTeamDefinition();
        if (teamDefHoldingVersions == null) {
            return;
        }
        try {
            VersionListDialog dialog = new VersionListDialog("Select Version", "Select Version to Release", AtsApiService.get().getVersionService().getVersions(teamDefHoldingVersions, VersionReleaseType.UnReleased, VersionLockedType.Both));
            int result = dialog.open();
            if (result == 0) {
                IAtsVersion version = (IAtsVersion)dialog.getSelectedFirst();
                if (!AtsApiService.get().getUserService().isAtsAdmin() && !AtsApiService.get().getTeamDefinitionService().getLeads(AtsApiService.get().getVersionService().getTeamDefinition(version)).contains(AtsApiService.get().getUserService().getCurrentUser())) {
                    AWorkbench.popup((String)"ERROR", (String)"Only lead can release version.");
                    return;
                }
                String errorStr = null;
                for (IAtsTeamWorkflow team : AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(version)) {
                    if (team.getStateMgr().getStateType().isCancelled() || team.getStateMgr().getStateType().isCompleted()) continue;
                    errorStr = "All Team Workflows must be either Completed or Cancelled before releasing a version.\n\n" + team.getAtsId() + " - is in the\"" + team.getStateMgr().getCurrentStateName() + "\" state.";
                }
                if (errorStr != null) {
                    AWorkbench.popup((String)"ERROR", errorStr);
                }
                if (errorStr != null && !AtsApiService.get().getUserService().isAtsAdmin()) {
                    return;
                }
                if (errorStr != null && !MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Override", (String)"ATS Admin Enabled - Override completed condition and release anyway?")) {
                    return;
                }
                IAtsChangeSet changes = AtsApiService.get().createChangeSet(((Object)((Object)this)).getClass().getSimpleName());
                if (version != null) {
                    changes.setSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.NextVersion, (Object)false);
                    changes.setSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.Released, (Object)true);
                    changes.setSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.ReleaseDate, (Object)new Date());
                }
                changes.execute();
                if (MessageDialog.openQuestion((Shell)Displays.getActiveShell(), (String)"Select NEW Next Release Version", (String)"Release Complete.\n\nSelect NEW Next Release Version?") && (result = (dialog = new VersionListDialog("Select Next Release Version", "Select New Next Release Version", AtsApiService.get().getVersionService().getVersions(teamDefHoldingVersions))).open()) == 0) {
                    version = (IAtsVersion)dialog.getSelectedFirst();
                    if (version == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Select a version.");
                        return;
                    }
                    changes.setSoleAttributeValue((IAtsObject)version, (AttributeTypeToken)AtsAttributeTypes.NextVersion, (Object)true);
                    changes.execute();
                }
            }
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error releasing version");
        }
    }

    public IAtsTeamDefinition getReleaseableTeamDefinition() {
        if (this.teamDefHoldingVersions != null) {
            return this.teamDefHoldingVersions;
        }
        TeamDefinitionDialog dialog = new TeamDefinitionDialog();
        dialog.setInput(AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Active));
        int result = dialog.open();
        if (result == 0) {
            return (IAtsTeamDefinition)dialog.getSelectedFirst();
        }
        return null;
    }
}

