/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.ClassServiceFactory;
import org.eclipse.jdt.apt.core.internal.FactoryPluginManager;
import org.eclipse.jdt.apt.core.internal.IServiceFactory;
import org.eclipse.jdt.apt.core.internal.JarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.LoadFailureHandler;
import org.eclipse.jdt.apt.core.internal.Messages;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class AnnotationProcessorFactoryLoader {
    private static AnnotationProcessorFactoryLoader LOADER;
    private static final String JAR_EXTENSION = "jar";
    private static final Object cacheMutex;
    private final Map<IJavaProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes>> _project2Java5Factories = new HashMap<IJavaProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes>>();
    private final Map<IJavaProject, Map<IServiceFactory, FactoryPath.Attributes>> _project2Java6Factories = new HashMap<IJavaProject, Map<IServiceFactory, FactoryPath.Attributes>>();
    private final Map<IJavaProject, ClassLoader> _iterativeLoaders = new HashMap<IJavaProject, ClassLoader>();
    private final Map<IJavaProject, ClassLoader> _batchLoaders = new HashMap<IJavaProject, ClassLoader>();
    private final Map<String, Set<IJavaProject>> _container2Project = new HashMap<String, Set<IJavaProject>>();

    static {
        cacheMutex = new Object();
    }

    public static synchronized AnnotationProcessorFactoryLoader getLoader() {
        if (LOADER == null) {
            LOADER = new AnnotationProcessorFactoryLoader();
            LOADER.registerListener();
        }
        return LOADER;
    }

    private void registerListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceListener(), 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAll() {
        this.removeAptBuildProblemMarkers(null);
        HashSet<ClassLoader> toClose = new HashSet<ClassLoader>();
        Object object = cacheMutex;
        synchronized (object) {
            toClose.addAll(this._iterativeLoaders.values());
            toClose.addAll(this._batchLoaders.values());
            this._project2Java5Factories.clear();
            this._project2Java6Factories.clear();
            this._iterativeLoaders.clear();
            this._container2Project.clear();
            this._batchLoaders.clear();
        }
        for (ClassLoader cl : toClose) {
            AnnotationProcessorFactoryLoader.tryToCloseClassLoader(cl);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            this.verifyFactoryPath(JavaCore.create((IProject)proj));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBatchProcessors(IJavaProject javaProj) {
        ClassLoader c;
        Map<IServiceFactory, FactoryPath.Attributes> java6factories;
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories;
        Collection<FactoryPath.Attributes> attrs = null;
        Object object = cacheMutex;
        synchronized (object) {
            factories = this._project2Java5Factories.get(javaProj);
            java6factories = this._project2Java6Factories.get(javaProj);
        }
        if (factories != null) {
            attrs = factories.values();
        } else if (java6factories != null) {
            attrs = java6factories.values();
        } else {
            return;
        }
        boolean batchProcsFound = false;
        for (FactoryPath.Attributes attr : attrs) {
            if (!attr.runInBatchMode()) continue;
            batchProcsFound = true;
            break;
        }
        Object object2 = cacheMutex;
        synchronized (object2) {
            if (batchProcsFound) {
                this._project2Java5Factories.remove(javaProj);
                this._project2Java6Factories.remove(javaProj);
            }
            c = this._batchLoaders.remove(javaProj);
        }
        AnnotationProcessorFactoryLoader.tryToCloseClassLoader(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AnnotationProcessorFactory, FactoryPath.Attributes> getJava5FactoriesAndAttributesForProject(IJavaProject jproj) {
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories;
        LoadFailureHandler failureHandler = new LoadFailureHandler(jproj);
        Object object = cacheMutex;
        synchronized (object) {
            factories = this._project2Java5Factories.get(jproj);
        }
        if (factories == null) {
            FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
            Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
            this.loadFactories(containers, jproj, failureHandler);
            failureHandler.reportFailureMarkers();
            Object object2 = cacheMutex;
            synchronized (object2) {
                factories = this._project2Java5Factories.get(jproj);
            }
        }
        if (factories != null) {
            return Collections.unmodifiableMap(factories);
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IServiceFactory, FactoryPath.Attributes> getJava6FactoriesAndAttributesForProject(IJavaProject jproj) {
        Map<IServiceFactory, FactoryPath.Attributes> factories;
        LoadFailureHandler failureHandler = new LoadFailureHandler(jproj);
        Object object = cacheMutex;
        synchronized (object) {
            factories = this._project2Java6Factories.get(jproj);
        }
        if (factories == null) {
            FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
            Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
            this.loadFactories(containers, jproj, failureHandler);
            Object object2 = cacheMutex;
            synchronized (object2) {
                factories = this._project2Java6Factories.get(jproj);
            }
        }
        failureHandler.reportFailureMarkers();
        if (factories != null) {
            return Collections.unmodifiableMap(factories);
        }
        return Collections.emptyMap();
    }

    public List<AnnotationProcessorFactory> getJava5FactoriesForProject(IJavaProject jproj) {
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factoriesAndAttrs = this.getJava5FactoriesAndAttributesForProject(jproj);
        ArrayList<AnnotationProcessorFactory> factories = new ArrayList<AnnotationProcessorFactory>(factoriesAndAttrs.keySet());
        return Collections.unmodifiableList(factories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToResourcesMap(String key, IJavaProject jproj) {
        Object object = cacheMutex;
        synchronized (object) {
            Set<IJavaProject> s = this._container2Project.get(key);
            if (s == null) {
                s = new HashSet<IJavaProject>();
                this._container2Project.put(key, s);
            }
            s.add(jproj);
        }
    }

    private Object loadInstance(String factoryName, ClassLoader cl, IJavaProject jproj, LoadFailureHandler failureHandler) {
        Object f = null;
        try {
            Class<?> c = cl.loadClass(factoryName);
            f = c.newInstance();
        }
        catch (Exception e) {
            AptPlugin.trace("Failed to load factory " + factoryName, e);
            failureHandler.addFailedFactory(factoryName);
        }
        catch (NoClassDefFoundError ncdfe) {
            AptPlugin.trace("Failed to load " + factoryName, ncdfe);
            failureHandler.addFailedFactory(factoryName);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFactories(Map<FactoryContainer, FactoryPath.Attributes> containers, IJavaProject project, LoadFailureHandler failureHandler) {
        ClassLoader iterativeClassLoader;
        LinkedHashMap<AnnotationProcessorFactory, FactoryPath.Attributes> java5Factories = new LinkedHashMap<AnnotationProcessorFactory, FactoryPath.Attributes>();
        LinkedHashMap<IServiceFactory, FactoryPath.Attributes> java6Factories = new LinkedHashMap<IServiceFactory, FactoryPath.Attributes>();
        this.removeAptBuildProblemMarkers(project);
        Set<FactoryContainer> badContainers = this.verifyFactoryPath(project);
        if (badContainers != null) {
            for (FactoryContainer badFC : badContainers) {
                failureHandler.addFailedFactory(badFC.getId());
                containers.remove(badFC);
            }
        }
        Object object = cacheMutex;
        synchronized (object) {
            iterativeClassLoader = this._iterativeLoaders.get(project);
            if (iterativeClassLoader == null) {
                iterativeClassLoader = AnnotationProcessorFactoryLoader._createIterativeClassLoader(containers);
                this._iterativeLoaders.put(project, iterativeClassLoader);
            }
        }
        ClassLoader batchClassLoader = this._createBatchClassLoader(containers, project);
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            try {
                FactoryContainer fc = entry.getKey();
                FactoryPath.Attributes attr = entry.getValue();
                assert (!attr.runInBatchMode() || batchClassLoader != null);
                ClassLoader cl = attr.runInBatchMode() ? batchClassLoader : iterativeClassLoader;
                List<AnnotationProcessorFactory> java5FactoriesInContainer = this.loadJava5FactoryClasses(fc, cl, project, failureHandler);
                for (AnnotationProcessorFactory apf : java5FactoriesInContainer) {
                    java5Factories.put(apf, entry.getValue());
                }
                if (!AptPlugin.canRunJava6Processors()) continue;
                List<IServiceFactory> java6FactoriesInContainer = this.loadJava6FactoryClasses(fc, cl, project, failureHandler);
                for (IServiceFactory isf : java6FactoriesInContainer) {
                    java6Factories.put(isf, entry.getValue());
                }
            }
            catch (FileNotFoundException fnfe) {
                AptPlugin.log(fnfe, String.valueOf(Messages.AnnotationProcessorFactoryLoader_jarNotFound) + fnfe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, String.valueOf(Messages.AnnotationProcessorFactoryLoader_ioError) + ioe.getLocalizedMessage());
            }
        }
        Object object2 = cacheMutex;
        synchronized (object2) {
            this._project2Java5Factories.put(project, java5Factories);
            this._project2Java6Factories.put(project, java6Factories);
        }
    }

    private List<AnnotationProcessorFactory> loadJava5FactoryClasses(FactoryContainer fc, ClassLoader classLoader, IJavaProject jproj, LoadFailureHandler failureHandler) throws IOException {
        Map<String, String> factoryNames = fc.getFactoryNames();
        ArrayList<AnnotationProcessorFactory> factories = new ArrayList<AnnotationProcessorFactory>();
        for (Map.Entry<String, String> entry : factoryNames.entrySet()) {
            if (!"com.sun.mirror.apt.AnnotationProcessorFactory".equals(entry.getValue())) continue;
            String factoryName = entry.getKey();
            AnnotationProcessorFactory factory = fc.getType() == FactoryContainer.FactoryType.PLUGIN ? FactoryPluginManager.getJava5FactoryFromPlugin(factoryName) : (AnnotationProcessorFactory)this.loadInstance(factoryName, classLoader, jproj, failureHandler);
            if (factory == null) continue;
            factories.add(factory);
        }
        return factories;
    }

    private List<IServiceFactory> loadJava6FactoryClasses(FactoryContainer fc, ClassLoader classLoader, IJavaProject jproj, LoadFailureHandler failureHandler) throws IOException {
        Map<String, String> factoryNames = fc.getFactoryNames();
        ArrayList<IServiceFactory> factories = new ArrayList<IServiceFactory>();
        for (Map.Entry<String, String> entry : factoryNames.entrySet()) {
            if (!"javax.annotation.processing.Processor".equals(entry.getValue())) continue;
            String factoryName = entry.getKey();
            IServiceFactory factory = null;
            if (fc.getType() == FactoryContainer.FactoryType.PLUGIN) {
                factory = FactoryPluginManager.getJava6FactoryFromPlugin(factoryName);
            } else {
                try {
                    Class<?> clazz = classLoader.loadClass(factoryName);
                    factory = new ClassServiceFactory(clazz);
                }
                catch (ClassFormatError | ClassNotFoundException e) {
                    AptPlugin.trace("Unable to load annotation processor " + factoryName, e);
                    failureHandler.addFailedFactory(factoryName);
                }
            }
            if (factory == null) continue;
            factories.add(factory);
        }
        return factories;
    }

    private void processChanges(Set<IJavaProject> affected, Map<IJavaProject, LoadFailureHandler> handlers) {
        for (IJavaProject jproj : affected) {
            this.removeAptBuildProblemMarkers(jproj);
            this.uncacheProject(jproj);
        }
        for (IJavaProject jproj : affected) {
            Set<FactoryContainer> badContainers;
            if (!jproj.exists() || (badContainers = this.verifyFactoryPath(jproj)) == null) continue;
            LoadFailureHandler handler = handlers.get(jproj);
            if (handler == null) {
                handler = new LoadFailureHandler(jproj);
                handlers.put(jproj, handler);
            }
            for (FactoryContainer container : badContainers) {
                handler.addMissingLibrary(container.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uncacheProject(IJavaProject jproj) {
        ClassLoader cl;
        ClassLoader c;
        Object object = cacheMutex;
        synchronized (object) {
            this._project2Java5Factories.remove(jproj);
            this._project2Java6Factories.remove(jproj);
            c = this._iterativeLoaders.remove(jproj);
            cl = this._batchLoaders.remove(jproj);
        }
        AnnotationProcessorFactoryLoader.tryToCloseClassLoader(c);
        AnnotationProcessorFactoryLoader.tryToCloseClassLoader(cl);
        this.removeProjectFromResourceMap(jproj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAptBuildProblemMarkers(IJavaProject jproj) {
        Set<IJavaProject> jprojects;
        Object object = cacheMutex;
        synchronized (object) {
            jprojects = jproj == null ? new HashSet<IJavaProject>(this._project2Java5Factories.keySet()) : Collections.singleton(jproj);
        }
        try {
            for (IJavaProject jp : jprojects) {
                IProject p;
                IMarker[] markers;
                if (!jp.exists() || (markers = (p = jp.getProject()).findMarkers("org.eclipse.jdt.apt.core.buildproblem", false, 0)) == null) continue;
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    marker.delete();
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to delete APT build problem marker");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProjectFromResourceMap(IJavaProject jproj) {
        Object object = cacheMutex;
        synchronized (object) {
            Iterator<Map.Entry<String, Set<IJavaProject>>> i = this._container2Project.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Set<IJavaProject>> e = i.next();
                Set<IJavaProject> s = e.getValue();
                s.remove(jproj);
                if (!s.isEmpty()) continue;
                i.remove();
            }
        }
    }

    private Set<FactoryContainer> verifyFactoryPath(IJavaProject jproj) {
        HashSet<FactoryContainer> badContainers = null;
        FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
        Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
        for (FactoryContainer fc : containers.keySet()) {
            if (fc instanceof JarFactoryContainer) {
                try {
                    File jarFile = ((JarFactoryContainer)fc).getJarFile();
                    if (jarFile != null) {
                        String key = jarFile.getCanonicalPath();
                        this.addToResourcesMap(key, jproj);
                    }
                }
                catch (IOException iOException) {}
            }
            if (fc.exists()) continue;
            if (badContainers == null) {
                badContainers = new HashSet<FactoryContainer>();
            }
            badContainers.add(fc);
        }
        return badContainers;
    }

    private static ClassLoader _createIterativeClassLoader(Map<FactoryContainer, FactoryPath.Attributes> containers) {
        ArrayList<File> fileList = new ArrayList<File>(containers.size());
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            FactoryPath.Attributes attr = entry.getValue();
            FactoryContainer fc = entry.getKey();
            if (attr.runInBatchMode() || !(fc instanceof JarFactoryContainer)) continue;
            JarFactoryContainer jfc = (JarFactoryContainer)fc;
            fileList.add(jfc.getJarFile());
        }
        ClassLoader cl = fileList.size() > 0 ? AnnotationProcessorFactoryLoader.createClassLoader(fileList, AnnotationProcessorFactoryLoader.getParentClassLoader()) : AnnotationProcessorFactoryLoader.getParentClassLoader();
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader _createBatchClassLoader(Map<FactoryContainer, FactoryPath.Attributes> containers, IJavaProject p) {
        ArrayList<File> fileList = new ArrayList<File>(containers.size());
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            FactoryPath.Attributes attr = entry.getValue();
            FactoryContainer fc = entry.getKey();
            if (!attr.runInBatchMode() || !(fc instanceof JarFactoryContainer)) continue;
            JarFactoryContainer jfc = (JarFactoryContainer)fc;
            File f = jfc.getJarFile();
            fileList.add(f);
        }
        ClassLoader result = null;
        Object object = cacheMutex;
        synchronized (object) {
            ClassLoader parentCL = this._iterativeLoaders.get(p);
            if (parentCL == null) {
                parentCL = AnnotationProcessorFactoryLoader.getParentClassLoader();
            }
            if (fileList.size() > 0) {
                result = AnnotationProcessorFactoryLoader.createClassLoader(fileList, parentCL);
                this._batchLoaders.put(p, result);
            }
        }
        return result;
    }

    private static ClassLoader getParentClassLoader() {
        final ClassLoader loaderForComSunMirrorClasses = AnnotationProcessorFactoryLoader.class.getClassLoader();
        final ClassLoader loaderForEverythingElse = ClassLoader.getSystemClassLoader();
        return new ClassLoader(){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                if (name.startsWith("com.sun.mirror.") && (name.startsWith("com.sun.mirror.apt") || name.startsWith("com.sun.mirror.declaration") || name.startsWith("com.sun.mirror.type") || name.startsWith("com.sun.mirror.util"))) {
                    return loaderForComSunMirrorClasses.loadClass(name);
                }
                return loaderForEverythingElse.loadClass(name);
            }
        };
    }

    private static ClassLoader createClassLoader(List<File> files, ClassLoader parentCL) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        int i = 0;
        while (i < files.size()) {
            try {
                urls.add(files.get(i).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(urlArray, parentCL);
    }

    private static void tryToCloseClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)classLoader)).close();
            }
            catch (IOException e) {
                AptPlugin.log(e, "Unable to close class loader.");
            }
        }
    }

    private class FactoryPathDeltaVisitor
    implements IResourceDeltaVisitor {
        private Set<IJavaProject> _affected = null;

        private FactoryPathDeltaVisitor() {
        }

        private void addAffected(Set<IJavaProject> projects) {
            if (this._affected == null) {
                this._affected = new HashSet<IJavaProject>(5);
            }
            this._affected.addAll(projects);
        }

        public Set<IJavaProject> getAffectedProjects() {
            return this._affected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean visit(IResourceDelta delta) {
            block17: {
                switch (delta.getKind()) {
                    default: {
                        return true;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                }
                IResource res = delta.getResource();
                if (res == null) {
                    return true;
                }
                IProject proj = res.getProject();
                if (FactoryPathUtil.isFactoryPathFile(res)) {
                    this.addAffected(Collections.singleton(JavaCore.create((IProject)proj)));
                    return true;
                }
                if (res.getType() != 1) {
                    return true;
                }
                IPath relativePath = res.getFullPath();
                String ext = relativePath.getFileExtension();
                try {
                    if (!AnnotationProcessorFactoryLoader.JAR_EXTENSION.equals(ext)) break block17;
                    IPath absolutePath = res.getLocation();
                    if (absolutePath == null) {
                        Object object = cacheMutex;
                        synchronized (object) {
                            for (Map.Entry entry : AnnotationProcessorFactoryLoader.this._container2Project.entrySet()) {
                                Path jarPath = new Path((String)entry.getKey());
                                if (!relativePath.lastSegment().equals(jarPath.lastSegment())) continue;
                                this.addAffected((Set)entry.getValue());
                            }
                            break block17;
                        }
                    }
                    String key = null;
                    key = absolutePath.toFile().getCanonicalPath();
                    Object object = cacheMutex;
                    synchronized (object) {
                        Set projects = (Set)AnnotationProcessorFactoryLoader.this._container2Project.get(key);
                        if (projects != null) {
                            this.addAffected(projects);
                        }
                    }
                }
                catch (Exception e) {
                    AptPlugin.log(e, "Couldn't determine whether any factory paths were affected by change to resource " + res.getName());
                }
            }
            return true;
        }
    }

    private class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            HashMap failureHandlers = new HashMap();
            switch (event.getType()) {
                case 4: {
                    IJavaProject jproj;
                    IResource project = event.getResource();
                    if (project == null || !(project instanceof IProject) || (jproj = JavaCore.create((IProject)((IProject)project))) == null) break;
                    AnnotationProcessorFactoryLoader.this.uncacheProject(jproj);
                    break;
                }
                case 8: {
                    IResourceDelta rootDelta = event.getDelta();
                    FactoryPathDeltaVisitor visitor = new FactoryPathDeltaVisitor();
                    try {
                        rootDelta.accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        AptPlugin.log(e, "Unable to determine whether resource change affects annotation processor factory path");
                    }
                    Set<IJavaProject> affected = visitor.getAffectedProjects();
                    if (affected == null) break;
                    AnnotationProcessorFactoryLoader.this.processChanges(affected, failureHandlers);
                }
            }
            for (LoadFailureHandler handler : failureHandlers.values()) {
                handler.reportFailureMarkers();
            }
        }
    }
}

