/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.operations;

import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.threading.ThreadedWorkerExecutor;
import org.eclipse.osee.framework.core.threading.ThreadedWorkerFactory;
import org.eclipse.osee.framework.jdk.core.util.ChecksumUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.skynet.core.OseeSystemArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.define.parser.BaseOutfileParser;
import org.eclipse.osee.ote.define.utilities.OutfileDataCollector;
import org.eclipse.osee.ote.define.utilities.OutfileParserExtensionManager;

public class OutfileToArtifactOperation {
    private final BranchToken branch;
    private final List<URI> filesToImport;
    private final List<Artifact> results;
    private final List<URI> filesWithErrors;

    public OutfileToArtifactOperation(BranchToken branch, URI ... filesToImport) {
        this.branch = branch;
        this.filesToImport = Arrays.asList(filesToImport);
        this.results = new ArrayList<Artifact>();
        this.filesWithErrors = new ArrayList<URI>();
    }

    public void execute(final IProgressMonitor monitor) throws Exception {
        this.results.clear();
        monitor.setTaskName("Outfiles to Artifact Conversion...");
        final Artifact parent = this.getParentArtifact();
        ThreadedWorkerFactory<Object> outfileToArtifactFactory = new ThreadedWorkerFactory<Object>(){

            public int getWorkSize() {
                return OutfileToArtifactOperation.this.filesToImport.size();
            }

            public Callable<Object> createWorker(int startIndex, int endIndex) {
                return new OutfileToArtifactCallable(monitor, parent, OutfileToArtifactOperation.this.filesToImport.subList(startIndex, endIndex));
            }
        };
        ThreadedWorkerExecutor executor = new ThreadedWorkerExecutor((ThreadedWorkerFactory)outfileToArtifactFactory, false);
        executor.executeWorkersBlocking();
    }

    private Artifact getParentArtifact() {
        Artifact scriptFolder;
        Artifact testFolder;
        Artifact root = OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)this.branch);
        if (!root.isRelated(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)(testFolder = OseeSystemArtifacts.getOrCreateArtifact((ArtifactTypeToken)CoreArtifactTypes.Folder, (String)"Test", (BranchToken)this.branch)))) {
            root.addChild(testFolder);
            root.persist("New Test Folder");
        }
        if (!testFolder.isRelated(CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)(scriptFolder = OseeSystemArtifacts.getOrCreateArtifact((ArtifactTypeToken)CoreArtifactTypes.Folder, (String)"Test Script Results", (BranchToken)this.branch)))) {
            testFolder.addChild(scriptFolder);
            testFolder.persist("New Test Script Results Folder");
        }
        return scriptFolder;
    }

    private void addChecksum(ArtifactTestRunOperator operator, URL targetURL) throws Exception {
        try (InputStream inputStream = null;){
            inputStream = targetURL.openStream();
            String checkSum = ChecksumUtil.createChecksumAsString((InputStream)inputStream, (String)"MD5");
            operator.setChecksum(checkSum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutfileDataCollector getOutfileData(IProgressMonitor monitor, URL fileToImport) throws Exception {
        BaseOutfileParser outfileParser;
        OutfileDataCollector collector = new OutfileDataCollector();
        BaseOutfileParser baseOutfileParser = outfileParser = OutfileParserExtensionManager.getInstance().getOutfileParserFor(fileToImport);
        synchronized (baseOutfileParser) {
            outfileParser.registerListener(collector);
            outfileParser.execute(monitor, fileToImport);
            outfileParser.deregisterListener(collector);
        }
        return collector;
    }

    public Artifact[] getResults() {
        return this.results.toArray(new Artifact[this.results.size()]);
    }

    public URI[] getUnparseableFiles() {
        return this.filesWithErrors.toArray(new URI[this.filesWithErrors.size()]);
    }

    private class OutfileToArtifactCallable
    implements Callable<Object> {
        private final IProgressMonitor monitor;
        private final Artifact parent;
        private final List<URI> filesToImport;

        public OutfileToArtifactCallable(IProgressMonitor monitor, Artifact parent, List<URI> filesToImport) {
            this.monitor = monitor;
            this.parent = parent;
            this.filesToImport = filesToImport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            for (URI targetUri : this.filesToImport) {
                ArtifactTestRunOperator operator = null;
                try {
                    operator = ArtifactTestRunOperator.getNewArtifactWithOperator(OutfileToArtifactOperation.this.branch);
                    OutfileDataCollector collector = OutfileToArtifactOperation.this.getOutfileData(this.monitor, targetUri.toURL());
                    collector.populate(operator.getTestRunArtifact(), this.parent);
                    String path = targetUri.toURL().toString();
                    operator.setLocalOutfileURI(path);
                    operator.setOutfileExtension(Lib.getExtension((String)path));
                    OutfileToArtifactOperation.this.addChecksum(operator, targetUri.toURL());
                    List list = OutfileToArtifactOperation.this.results;
                    synchronized (list) {
                        OutfileToArtifactOperation.this.results.add(operator.getTestRunArtifact());
                    }
                    if (this.monitor.isCanceled()) {
                        break;
                    }
                }
                catch (Exception exception) {
                    if (operator == null || operator.getTestRunArtifact() == null) {
                        throw new Exception("Unable to create Test Run Artifact. Make sure type information exists in the selected branch.");
                    }
                    List list = OutfileToArtifactOperation.this.filesWithErrors;
                    synchronized (list) {
                        OutfileToArtifactOperation.this.filesWithErrors.add(targetUri);
                    }
                }
                operator = null;
                this.monitor.worked(1);
            }
            return null;
        }
    }
}

