/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.jobs;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.viewers.XViewerDataManager;

public class AddArtifactsToViewerJob
extends Job {
    private static final String JOB_NAME = "Adding Artifacts to Table";
    private final List<Artifact> artifacts;
    private final XViewerDataManager viewerDataManager;

    public AddArtifactsToViewerJob(XViewerDataManager viewerDataManager, List<Artifact> artifacts) {
        super(JOB_NAME);
        this.artifacts = artifacts;
        this.viewerDataManager = viewerDataManager;
        this.setUser(true);
        this.setPriority(30);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus toReturn = Status.CANCEL_STATUS;
        monitor.beginTask(this.getName(), this.artifacts.size());
        try {
            this.viewerDataManager.addArtifacts(monitor, this.artifacts);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return new Status(4, "org.eclipse.osee.ote.ui.define", -1, ex.getMessage(), (Throwable)ex);
        }
        if (!monitor.isCanceled()) {
            toReturn = Status.OK_STATUS;
        }
        monitor.done();
        return toReturn;
    }
}

