/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.define.api.importing.ReqNumbering;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class OutlineResolution {
    public boolean isInvalidOutlineNumber(String currentOutlineNumber, String lastOutlineNumber) {
        boolean resolution = Strings.isValid((CharSequence[])new CharSequence[]{currentOutlineNumber, lastOutlineNumber});
        if (resolution) {
            ReqNumbering current = new ReqNumbering(currentOutlineNumber, false);
            ReqNumbering last = new ReqNumbering(lastOutlineNumber, false);
            resolution = this.isInvalidOutlineNumber(current, last);
        }
        return resolution;
    }

    public boolean isInvalidOutlineNumber(ReqNumbering current, ReqNumbering last) {
        boolean invalid = Conditions.notNull((Object[])new Object[]{current, last});
        if (invalid) {
            switch (last.compareTo(current)) {
                case -1: {
                    Set<String> nextUp = this.generateNextSet(last);
                    boolean bl = invalid = !nextUp.contains(current.getNumberString());
                    if (!invalid) break;
                    invalid = current.getNumberString().length() - last.getNumberString().length() < 4;
                    break;
                }
                default: {
                    invalid = true;
                }
            }
        }
        return invalid;
    }

    public Set<String> generateNextSet(ReqNumbering lastNumberParagrah) {
        HashSet<String> nextParagraphs = new HashSet<String>();
        String last = lastNumberParagrah.getNumberString();
        if (last.endsWith(".0")) {
            last = last.substring(0, last.length() - ".0".length());
        }
        if (!(last = Strings.truncateEndChar((String)last, (int)46)).endsWith(".0.1")) {
            nextParagraphs.add(String.valueOf(last) + ".0.1");
            nextParagraphs.add(String.valueOf(last) + ".1");
        }
        String[] digits = last.split("\\.");
        int i = 0;
        while (i < digits.length) {
            int incDigit = this.extractDigitsSafely(digits[i]) + 1;
            if (i == 0) {
                nextParagraphs.add(String.valueOf(incDigit) + ".0");
                nextParagraphs.add(Integer.toString(incDigit));
            } else {
                StringBuilder nextNew = new StringBuilder(digits.length * 2);
                int j = 0;
                while (j < i) {
                    nextNew.append(String.valueOf(digits[j]) + ".");
                    ++j;
                }
                nextParagraphs.add(String.valueOf(nextNew.toString()) + Integer.toString(incDigit));
            }
            ++i;
        }
        HashSet<String> dotEnding = new HashSet<String>(nextParagraphs.size());
        for (String next : nextParagraphs) {
            dotEnding.add(String.valueOf(next) + ".");
        }
        nextParagraphs.addAll(dotEnding);
        return nextParagraphs;
    }

    private int extractDigitsSafely(String stringContainingDigit) {
        int returnValue = 0;
        try {
            returnValue = Integer.parseInt(stringContainingDigit);
        }
        catch (NumberFormatException numberFormatException) {}
        return returnValue;
    }
}

