/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.osgi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcClientBuilder;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.JdbcLogger;
import org.eclipse.osee.jdbc.JdbcServer;
import org.eclipse.osee.jdbc.JdbcServerBuilder;
import org.eclipse.osee.jdbc.JdbcServerConfig;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.internal.JdbcUtil;
import org.eclipse.osee.logger.Log;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"OseeJdbc"}, factory="org.eclipse.osee.jdbc.JdbcService", property={"jdbc.server.host=127.0.0.1", "jdbc.server.port=8088", "jdbc.server.db.data.path=file:demo/hsql/osee.hsql.db", "jdbc.client.db.username=public", "jdbc.client.connection.pool.enabled=true", "jdbc.client.connection.pool.max.active.connections=100", "jdbc.client.connection.pool.max.idle.connections=100"})
public class JdbcServiceImpl
implements JdbcService {
    private final AtomicReference<JdbcServer> serverRef = new AtomicReference();
    private final AtomicReference<JdbcClient> clientRef = new AtomicReference();
    private final JdbcClient clientProxy = this.createClientProxy();
    private Log logger;
    private ExecutorAdmin executorAdmin;
    private volatile Map<String, Object> config;

    private JdbcServer getServer() {
        return this.serverRef.get();
    }

    @Reference
    void setLogger(Log logger) {
        this.logger = logger;
    }

    @Reference
    void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    @Activate
    void activate(Map<String, Object> props) {
        this.executorAdmin.submitAndWait("Start JDBC service", () -> this.modified(props), 20L, TimeUnit.SECONDS);
    }

    @Deactivate
    void stop(Map<String, Object> props) {
        JdbcServer server = this.getServer();
        if (server != null) {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    void modified(Map<String, Object> props) {
        this.config = props;
        AtomicReference<JdbcClient> atomicReference = this.clientRef;
        synchronized (atomicReference) {
            JdbcServer server = this.newServer(props);
            JdbcClientBuilder builder = JdbcClientBuilder.newBuilder(props);
            if (JdbcServiceImpl.hasServerConfig(props)) {
                String serverPassword;
                String serverUsername;
                JdbcServerConfig serverConfig = server.getConfig();
                if (!Strings.isValid((String)builder.getDbUri())) {
                    builder = builder.fromType(JdbcConstants.JdbcDriverType.hsql, serverConfig.getDbName(), serverConfig.getDbPort());
                }
                if (!Strings.isValid((String)builder.getDbUsername()) && Strings.isValid((String)(serverUsername = serverConfig.getDbUsername()))) {
                    builder.dbUsername(serverUsername);
                }
                if (!Strings.isValid((String)builder.getDbPassword()) && Strings.isValid((String)(serverPassword = serverConfig.getDbPassword()))) {
                    builder.dbPassword(serverPassword);
                }
            }
            this.clientRef.set(builder.build());
        }
    }

    private JdbcServer newServer(Map<String, Object> props) {
        JdbcServer oldServer;
        JdbcServer newServer = null;
        if (JdbcServiceImpl.hasServerConfig(props)) {
            String password;
            String username;
            JdbcServerBuilder builder = JdbcServerBuilder.newBuilder(props).logger(JdbcServiceImpl.asJdbcLogger(this.logger));
            if (!Strings.isValid((String)builder.getDbUsername()) && Strings.isValid((String)(username = JdbcUtil.get(props, "jdbc.client.db.username", null)))) {
                builder.dbUsername(username);
            }
            if (!Strings.isValid((String)builder.getDbPassword()) && Strings.isValid((String)(password = JdbcUtil.get(props, "jdbc.client.db.password", null)))) {
                builder.dbPassword(password);
            }
            newServer = builder.build();
        }
        if ((oldServer = (JdbcServer)this.serverRef.getAndSet(newServer)) != null) {
            oldServer.stop();
        }
        if (newServer != null) {
            newServer.start();
        }
        return newServer;
    }

    @Override
    public String getId() {
        return JdbcUtil.getServiceId(this.config);
    }

    @Override
    public JdbcClient getClient() {
        return this.clientProxy;
    }

    @Override
    public boolean hasServer() {
        return this.getServer() != null;
    }

    @Override
    public JdbcServerConfig getServerConfig() {
        JdbcServer server = this.getServer();
        return server != null ? server.getConfig() : null;
    }

    @Override
    public boolean isServerAlive(long waitTime) {
        JdbcServer server = this.getServer();
        return server != null ? server.isAlive(waitTime) : false;
    }

    private static boolean hasServerConfig(Map<String, Object> props) {
        boolean result = false;
        for (String key : props.keySet()) {
            if (!key.startsWith("jdbc.server.")) continue;
            result = true;
            break;
        }
        return result;
    }

    private static JdbcLogger asJdbcLogger(final Log logger) {
        return new JdbcLogger(){

            @Override
            public void info(String msg, Object ... data) {
                logger.info(msg, data);
            }

            @Override
            public void error(Throwable ex, String msg, Object ... data) {
                logger.error(ex, msg, data);
            }

            @Override
            public void error(String msg, Object ... data) {
                logger.error(msg, data);
            }

            @Override
            public void debug(String msg, Object ... data) {
                logger.debug(msg, data);
            }
        };
    }

    private JdbcClient createClientProxy() {
        JdbcClientInvocationHandler handler = new JdbcClientInvocationHandler();
        Class[] types = new Class[]{JdbcClient.class};
        return (JdbcClient)Proxy.newProxyInstance(this.getClass().getClassLoader(), types, (InvocationHandler)handler);
    }

    private final class JdbcClientInvocationHandler
    implements InvocationHandler {
        private JdbcClientInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            JdbcClient client = null;
            int x = 0;
            while (x < 5) {
                client = (JdbcClient)JdbcServiceImpl.this.clientRef.get();
                if (client != null) break;
                XConsoleLogger.err((String)"sleeping to get JDBC Client", (Object[])new Object[0]);
                Thread.sleep(1000L);
                ++x;
            }
            if (client == null) {
                String msg = "JDBC client not available.  If using an embedded database, it may have hung.";
                XConsoleLogger.err((String)msg, (Object[])new Object[0]);
                throw new OseeStateException(msg, new Object[0]);
            }
            try {
                return method.invoke((Object)client, args);
            }
            catch (Throwable ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                throw cause;
            }
        }
    }
}

