/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.network.PortUtil;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.SQL3DataType;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;

public final class JdbcUtil {
    private JdbcUtil() {
    }

    public static <O> void setInputParametersForStatement(PreparedStatement preparedStatement, O ... data) throws JdbcException {
        JdbcUtil.setInputParametersForStatement(preparedStatement, 1, data);
    }

    public static <O> void setInputParametersForStatement(PreparedStatement preparedStatement, int intialIndex, O ... data) throws JdbcException {
        int preparedIndex = intialIndex;
        O[] OArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            O dataValue = OArray[n2];
            JdbcUtil.setInputParameterForStatement(preparedStatement, dataValue, preparedIndex++);
            ++n2;
        }
    }

    public static boolean isValidExtraParam(String key) {
        return Strings.isValid((String)key) && (key.startsWith("jdbc.") || key.equalsIgnoreCase("service.id") || key.equalsIgnoreCase("objectClass") || key.equalsIgnoreCase("component.id") || key.equalsIgnoreCase("component.name"));
    }

    public static <O> void setInputParameterForStatement(PreparedStatement statement, O dataValue, int preparedIndex) throws JdbcException {
        try {
            if (dataValue instanceof String) {
                JdbcUtil.checkStringDataLength(dataValue);
            }
            if (dataValue == null) {
                throw JdbcException.newJdbcException("instead of passing null for an input parameter, pass the corresponding SQL3DataType", new Object[0]);
            }
            if (dataValue instanceof SQL3DataType) {
                int dataTypeNumber = ((SQL3DataType)((Object)dataValue)).getSQLTypeNumber();
                if (dataTypeNumber == 2004) {
                    statement.setBytes(preparedIndex, null);
                } else {
                    statement.setNull(preparedIndex, dataTypeNumber);
                }
            } else if (dataValue instanceof ByteArrayInputStream) {
                statement.setBinaryStream(preparedIndex, (InputStream)((ByteArrayInputStream)dataValue), ((ByteArrayInputStream)dataValue).available());
            } else if (dataValue instanceof Date) {
                Date javaDate = (Date)dataValue;
                Timestamp date = new Timestamp(javaDate.getTime());
                statement.setTimestamp(preparedIndex, date);
            } else if (dataValue instanceof BigInteger) {
                BigInteger bigInt = (BigInteger)dataValue;
                statement.setLong(preparedIndex, bigInt.longValue());
            } else if (dataValue instanceof BigDecimal) {
                BigDecimal bigDec = (BigDecimal)dataValue;
                statement.setLong(preparedIndex, bigDec.longValue());
            } else if (dataValue instanceof Id) {
                Id id = (Id)dataValue;
                statement.setLong(preparedIndex, id.getId());
            } else if (dataValue instanceof Identity) {
                Identity id = (Identity)dataValue;
                statement.setInt(preparedIndex, (Integer)id.getGuid());
            } else if (dataValue instanceof String) {
                statement.setString(preparedIndex, (String)dataValue);
            } else {
                statement.setObject(preparedIndex, dataValue);
            }
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    private static void checkStringDataLength(Object dataValue) {
        int length = ((String)dataValue).length();
        if (length > 4000) {
            throw JdbcException.newJdbcException("SQL data value length must be <= %d not %d\nValue: %s", 4000, length, dataValue);
        }
    }

    public static JdbcConnectionInfo newConnectionInfo(final String dbDriver, String dbUri, final Properties dbProps, boolean appendPropsToUri) {
        String connectionUri;
        StringBuilder builder;
        JdbcUtil.checkNotNullOrEmpty(dbDriver, "database driver");
        JdbcUtil.checkNotNullOrEmpty(dbUri, "database uri");
        if (appendPropsToUri && !dbProps.isEmpty()) {
            builder = new StringBuilder(dbUri);
            for (Map.Entry<Object, Object> entry : dbProps.entrySet()) {
                builder.append(String.format(";%s=%s", entry.getKey(), entry.getValue()));
            }
            connectionUri = builder.toString();
        } else {
            connectionUri = dbUri;
        }
        builder = new StringBuilder();
        JdbcUtil.add(builder, dbDriver);
        JdbcUtil.add(builder, connectionUri);
        final String connectionId = builder.toString();
        return new JdbcConnectionInfo(){

            @Override
            public String getId() {
                return connectionId;
            }

            @Override
            public String getDriver() {
                return dbDriver;
            }

            @Override
            public String getUri() {
                return connectionUri;
            }

            @Override
            public Properties getProperties() {
                return dbProps;
            }

            public String toString() {
                return "JdbcConnectionInfo [id=" + this.getId() + ", driver=" + this.getDriver() + ", uri=" + this.getUri() + ", props=" + this.getProperties();
            }
        };
    }

    private static void add(StringBuilder builder, String value) {
        if (Strings.isValid((String)value)) {
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(value);
        }
    }

    private static void checkNotNull(Object object, String objectName) {
        if (object == null) {
            throw JdbcException.newJdbcException("%s cannot be null", objectName);
        }
    }

    private static void checkNotNullOrEmpty(String object, String objectName) {
        JdbcUtil.checkNotNull(object, objectName);
        if (object.length() == 0) {
            throw JdbcException.newJdbcException("%s cannot be empty", objectName);
        }
    }

    public static long getLong(Map<String, Object> props, String key, long defaultValue) {
        String toReturn = JdbcUtil.get(props, key, String.valueOf(defaultValue));
        return Strings.isNumeric((String)toReturn) ? Long.parseLong(toReturn) : -1L;
    }

    public static int getInt(Map<String, Object> props, String key, int defaultValue) {
        String toReturn = JdbcUtil.get(props, key, String.valueOf(defaultValue));
        return Strings.isNumeric((String)toReturn) ? Integer.parseInt(toReturn) : -1;
    }

    public static boolean getBoolean(Map<String, Object> props, String key, boolean defaultValue) {
        String toReturn = JdbcUtil.get(props, key, String.valueOf(defaultValue));
        return Boolean.parseBoolean(toReturn);
    }

    public static String get(Map<String, Object> props, String key, String defaultValue) {
        Object object;
        String toReturn = defaultValue;
        Object object2 = object = props != null ? props.get(key) : null;
        if (object != null) {
            toReturn = String.valueOf(object);
        }
        return toReturn;
    }

    public static JdbcConstants.PoolExhaustedAction getExhaustedAction(Map<String, Object> props, String key, JdbcConstants.PoolExhaustedAction defaultValue) {
        String toReturn = JdbcUtil.get(props, key, String.valueOf((Object)defaultValue));
        return JdbcConstants.PoolExhaustedAction.fromString(toReturn);
    }

    public static int getRandomPort() {
        PortUtil port = PortUtil.getInstance();
        try {
            return port.getValidPort();
        }
        catch (IOException ex) {
            throw JdbcException.newJdbcException(ex, "Error acquiring random port for JdbcServer", new Object[0]);
        }
    }

    public static String getServiceId(Map<String, Object> data) {
        return JdbcUtil.get(data, "service.id", null);
    }

    public static int calculateBatchUpdateResults(int[] updates) throws JdbcException {
        int returnCount = 0;
        int[] nArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            int update = nArray[n2];
            if (update >= 0) {
                returnCount += update;
            } else {
                if (-3 == update) {
                    throw JdbcException.newJdbcException("Batch update failed", new Object[0]);
                }
                if (-2 == update) {
                    ++returnCount;
                }
            }
            ++n2;
        }
        return returnCount;
    }

    public static void close(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

