/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.console;

import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.orcs.statistics.IndexerItemStatistics;
import org.eclipse.osee.orcs.statistics.IndexerStatistics;

public final class IndexerUtil {
    private IndexerUtil() {
    }

    public static void writeStatistics(Console console, IndexerStatistics stats) {
        console.writeln((Object)"\n----------------------------------------------");
        console.writeln((Object)"                  Indexer Stats");
        console.writeln((Object)"----------------------------------------------");
        console.writeln("Query Id Processing Time  - avg: [%s] ms - longest: [%s] ms", new Object[]{stats.getAverageQueryIdProcessingTime(), stats.getLongestQueryIdProcessingTime()});
        console.writeln("Query Id Wait Time        - avg: [%s] ms - longest: [%s] ms", new Object[]{stats.getAverageQueryIdWaitTime(), stats.getLongestQueryIdWaitTime()});
        console.writeln("Attribute Processing Time - avg: [%s] ms - longest: [%s] ms", new Object[]{stats.getAverageAttributeProcessingTime(), stats.getLongestAttributeProcessingTime()});
        console.writeln("Attribute with longest processing time - %s", new Object[]{IndexerUtil.toString(stats.getLongestTask())});
        console.writeln("Attribute with most tags - %s", new Object[]{IndexerUtil.toString(stats.getMostTagsTask())});
        console.writeln("Total - QueryIds: [%d] Attributes: [%d] Tags: [%d]", new Object[]{stats.getTotalQueryIdsProcessed(), stats.getTotalAttributesProcessed(), stats.getTotalTags()});
        console.writeln("Total Query Ids Waiting to be Processed - [%d]", new Object[]{stats.getWorkersInQueue()});
        console.writeln("Total Query Ids in Tag Queue Table - [%d]", new Object[]{stats.getTotalQueryIdsInQueue()});
        console.writeln("Total Tags in System - [%d]", new Object[]{stats.getTagsInSystem()});
    }

    private static String toString(IndexerItemStatistics item) {
        return String.format("id: [%d] - processed [%d] tags in [%d] ms", item.getId(), item.getTotalTags(), item.getProcessingTime());
    }
}

