/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.access;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.access.AbstractAccessControlService;
import org.eclipse.osee.framework.core.access.AccessTopicEventPayload;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.internal.access.AccessStoreOperations;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.BranchQuery;

public class AccessControlServiceImpl
extends AbstractAccessControlService {
    protected JdbcClient jdbcClient;
    private final OrcsApi orcsApi;
    private final OrcsTokenService tokenService;
    private Map<BranchId, BranchToken> branchIdToToken = null;

    public AccessControlServiceImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.tokenService = orcsApi.tokenService();
        this.jdbcClient = orcsApi.getJdbcService().getClient();
        this.setStoreOperations(new AccessStoreOperations(orcsApi));
    }

    public void removePermissions(BranchId branch) {
        this.jdbcClient.runPreparedUpdate("DELETE FROM OSEE_ARTIFACT_ACL WHERE  branch_id =?", new Object[]{branch});
        this.jdbcClient.runPreparedUpdate("DELETE FROM OSEE_BRANCH_ACL WHERE branch_id =?", new Object[]{branch});
    }

    public boolean isReadOnly(ArtifactToken artifact) {
        try {
            if (artifact instanceof ArtifactReadable) {
                boolean deleted = ((ArtifactReadable)artifact).isDeleted();
                boolean historical = ((ArtifactReadable)artifact).isHistorical();
                boolean hasPermission = this.hasArtifactPermission(artifact, PermissionEnum.WRITE, null).isSuccess();
                return deleted || historical || !hasPermission;
            }
            return true;
        }
        catch (OseeCoreException oseeCoreException) {
            return true;
        }
    }

    public boolean isOseeAdmin() {
        return this.orcsApi.userService().getUserGroup(CoreUserGroups.OseeAdmin).isCurrentUserMember();
    }

    public ArtifactToken getUserByArtId(ArtifactId subjectArtId) {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId(subjectArtId).getArtifactOrNull();
    }

    public void kickAccessTopicEvent(AccessTopicEventPayload event) {
    }

    public Collection<ArtifactToken> getArtifactListFromType(ArtifactTypeToken artType, BranchToken branch) {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andIsOfType(new ArtifactTypeToken[]{artType}).asArtifactTokens();
    }

    public boolean isBaselineBranch(BranchToken branch) {
        ResultSet branches = ((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId((BranchId)branch)).getResults();
        if (branches.size() == 1) {
            return ((Branch)branches.iterator().next()).getBranchType().isBaselineBranch();
        }
        return false;
    }

    protected boolean isInDbInit() {
        return OseeProperties.isInDbInit();
    }

    public boolean isInDb(ArtifactToken artifact) {
        return ((ArtifactReadable)artifact).getTransaction().equals(TransactionId.SENTINEL);
    }

    public ArtifactToken getUser() {
        return this.orcsApi.userService().getUser();
    }

    public ArtifactToken getArtifactFromId(ArtifactId subjectId, BranchToken branch) {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)branch).andId(subjectId).asArtifactTokenOrSentinel();
    }

    public void populateBranchCache() {
        if (this.branchIdToToken == null) {
            this.branchIdToToken = new HashMap<BranchId, BranchToken>();
            Consumer<JdbcStatement> consumer = stmt -> {
                String branchName = stmt.getString("branch_name");
                BranchId branchId = BranchId.valueOf((Long)stmt.getLong("branch_id"));
                BranchToken branch = BranchToken.create((BranchId)branchId, (String)branchName);
                this.branchIdToToken.put(branchId, branch);
            };
            this.jdbcClient.runQuery(consumer, "SELECT branch_id, branch_name from OSEE_BRANCH", new Object[0]);
        }
    }

    public void populateBranchAccessControlList() {
        this.populateBranchCache();
        Consumer<JdbcStatement> consumer = stmt -> {
            ArtifactId subjectId = ArtifactId.valueOf((Long)stmt.getLong("privilege_entity_id"));
            BranchId branchId = BranchId.valueOf((Long)stmt.getLong("branch_id"));
            BranchToken branch = this.branchIdToToken.get(branchId);
            if (branch == null) {
                branch = ((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branchId)).getOneOrSentinel();
                this.branchIdToToken.put(branchId, branch);
            }
            if (branch.isValid()) {
                PermissionEnum permission = PermissionEnum.getPermission((int)stmt.getInt("permission_id"));
                ArtifactTypeToken subjectArtifactType = this.tokenService.getArtifactType(Long.valueOf(stmt.getLong("art_type_id")));
                this.brchAclOps.populateBranchAccessControlListEntry(subjectId, subjectArtifactType, branch, permission);
            }
        };
        this.jdbcClient.runQuery(consumer, "SELECT bac1.*, art1.art_type_id FROM osee_artifact art1, osee_branch_acl bac1 WHERE art1.art_id = bac1.privilege_entity_id", new Object[0]);
    }

    public void populateArtifactAccessControlList() {
        Consumer<JdbcStatement> consumer = stmt -> {
            UserId subjectId = UserId.valueOf((Long)stmt.getLong("privilege_entity_id"));
            BranchId branchId = BranchId.valueOf((Long)stmt.getLong("branch_id"));
            PermissionEnum permission = PermissionEnum.getPermission((int)stmt.getInt("permission_id"));
            ArtifactTypeToken subjectArtifactType = this.tokenService.getArtifactType(Long.valueOf(stmt.getLong("art_type_id")));
            ArtifactToken artifact = ArtifactToken.valueOf((long)stmt.getLong("art_id"), (BranchId)branchId);
            this.artAclOps.populateArtifactAccessControlListEntry((ArtifactId)subjectId, artifact, permission, subjectArtifactType);
        };
        this.jdbcClient.runQuery(consumer, "SELECT aac1.*, art1.art_type_id FROM osee_artifact art1, osee_artifact_acl aac1 WHERE art1.art_id = aac1.privilege_entity_id", new Object[0]);
    }

    public void populateGroupMembers(ArtifactId groupId) {
        if (!this.cache.groupToSubjectsCache.containsKey((Object)groupId.getId())) {
            this.jdbcClient.runQuery(stmt -> {
                ArtifactId groupMember = ArtifactId.valueOf((Long)stmt.getLong("b_art_id"));
                this.userGrpOps.populateGroupMembersEntry(groupId, groupMember);
            }, "SELECT b_art_id FROM osee_relation_link WHERE a_art_id = ? AND rel_link_type_id = ? ORDER BY b_art_id", new Object[]{groupId, CoreRelationTypes.Users_User});
        }
    }
}

